package br.com.centralit.citcorpore.negocio;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AnexavelDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.util.CriptoUtils;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.integracao.ControleGEDDao;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;

@SuppressWarnings("unchecked")
public abstract class GEDGenericoServiceEjb<T extends AnexavelDTO> extends CrudServiceImpl implements UploadGenericoService<T> {

	private static final String DIRETORIO_PADRAO = "1";
	private static final String EXTENSAO_GED = ".ged";
	private static final String FS = System.getProperty("file.separator");
	private ControleGEDDao controleGEDDao;
	Class<T> classe;

	public abstract Integer getControleGEDDTOConstanteTabela();

	@Override
	public void update(IDto model) throws ServiceException, LogicException {
		if (!Util.isNullOrEmpty(model)) {
			super.update(model);
		}
	}

	public T executarAcaoSalvar(T anexavel, TransactionControler tc) throws PersistenceException, Exception {

		if (anexavel.getId() != null && anexavel.getId().intValue() > 0) {
			if (isServicoExiste(anexavel.getIdPai())) {
				getDao().update(anexavel);
			}
		} else {
			anexavel = (T) getDao().create(anexavel);
		}

		if (anexavel != null && anexavel.getColsUploadGED() != null && !anexavel.getColsUploadGED().isEmpty()) {
			gravarInformacaoGED(anexavel, tc);
		}

		return anexavel;
	}

	protected void gravarInformacaoGED(T anexavel, TransactionControler tc) throws Exception {
		definirTransacao(tc);
		tratarListaDeArquivoGED(anexavel);
	}

	private void definirTransacao(TransactionControler tc) {
		if (tc != null) {
			getControleGEDDao().setTransactionControler(tc);
		}
	}

	private void tratarListaDeArquivoGED(T anexavel) throws Exception {
		String pasta = definirDiretorioGed(anexavel);

		for (UploadDTO uploadDTO : anexavel.getColsUploadGED()) {
			if (uploadDTO.getTemporario().equals(SimNao.SIM.getValorStr())) {
				ControleGEDDTO controleGEDDTO = new ControleGEDDTO();

				definirControleGED(anexavel, pasta, uploadDTO, controleGEDDTO);
				definirPathArquivo(uploadDTO, controleGEDDTO);
				salvarSetarControleGED(uploadDTO, controleGEDDTO);
				criarGEDInternoBD(uploadDTO, controleGEDDTO);
			}
		}
	}

	private void criarGEDInternoBD(UploadDTO uploadDTO, ControleGEDDTO controleGEDDTO) throws Exception {
		if (getGedInternoBD().equalsIgnoreCase(SimNao.NAO.getValorStr())) {
			if (controleGEDDTO != null) {
				try {
					String caminho = getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO).concat(FS).concat(controleGEDDTO.getPasta()).concat(FS).concat(String.valueOf(controleGEDDTO.getIdControleGED()));

					File arquivo = new File(caminho.concat(".").concat(Util.getFileExtension(uploadDTO.getNameFile())));

					CriptoUtils.encryptFile(uploadDTO.getPath(), caminho.concat(EXTENSAO_GED), ((String) System.getProperties().get("user.dir")).concat(Constantes.getValue("CAMINHO_CHAVE_PUBLICA")));

					arquivo.delete();
				} catch (ClassNotFoundException | IOException | GeneralSecurityException e) {
					e.printStackTrace();
				}
			}
		}

	}

	private void definirControleGED(T anexavel, String pasta, UploadDTO uploadDTO, ControleGEDDTO controleGEDDTO) {
		controleGEDDTO.setIdTabela(getControleGEDDTOConstanteTabela());
		controleGEDDTO.setId(anexavel.getId());
		controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
		controleGEDDTO.setDescricaoArquivo(uploadDTO.getDescricao());
		controleGEDDTO.setExtensaoArquivo(Util.getFileExtension(uploadDTO.getNameFile()));
		controleGEDDTO.setPasta(pasta);
		controleGEDDTO.setNomeArquivo(uploadDTO.getNameFile());
	}

	private void salvarSetarControleGED(UploadDTO uploadDTO, ControleGEDDTO controleGEDDTO) throws PersistenceException {
		controleGEDDTO = (ControleGEDDTO) getControleGEDDao().create(controleGEDDTO);
		uploadDTO.setIdControleGED(controleGEDDTO.getIdControleGED());
	}

	private void definirPathArquivo(UploadDTO uploadDTO, ControleGEDDTO controleGEDDTO) {
		if (SimNao.SIM.getValorStr().equalsIgnoreCase(getGedInterno().trim()) && SimNao.SIM.getValorStr().equalsIgnoreCase(getGedInternoBD().trim())) {
			controleGEDDTO.setPathArquivo(uploadDTO.getPath());
		} else {
			controleGEDDTO.setPathArquivo(null);
		}
	}

	@Override
	public void removerAnexosDiretorioGed(DocumentHTML document, T anexavel) throws PersistenceException {
		TransactionControler tc = new TransactionControlerImpl(getDao().getAliasDB());
		try {
			deletarArquivos(document, anexavel, tc);
		} catch (Exception e) {
			e.printStackTrace();
			try {
				rollbackTransaction(tc, e);
			} catch (ServiceException | LogicException e1) {
				e1.printStackTrace();
			}
			tc.close();
		}

	}

	private void deletarArquivos(DocumentHTML document, T anexavel, TransactionControler tc) throws Exception {
		if (anexavel.getColsUploadGEDExcluidos() != null && !anexavel.getColsUploadGEDExcluidos().isEmpty()) {
			String gedDiretorio = getGedDiretorio();

			for (String valorId : anexavel.getColsUploadGEDExcluidos()) {
				if (valorId.startsWith("ID=")) {
					tc.start();
					definirTransacao(tc);

					ControleGEDDTO controleGEDDTO = new ControleGEDDTO();
					controleGEDDTO.setIdControleGED(obterIdParaExclusaoGed(valorId));
					controleGEDDTO = (ControleGEDDTO) getControleGEDDao().restore(controleGEDDTO);
					getControleGEDDao().delete(controleGEDDTO);

					File arquivo = new File(gedDiretorio.concat(FS).concat(DIRETORIO_PADRAO).concat(FS).concat(controleGEDDTO.getPasta()).concat(FS).concat(String.valueOf(controleGEDDTO.getIdControleGED())).concat(EXTENSAO_GED));

					deleteDir(arquivo);
					tc.commit();
				} else {
					File arquivoTemporario = new File(valorId);

					deleteDir(arquivoTemporario);
				}
			}
		}
	}

	private boolean deleteDir(File dir) {
		if (dir.isDirectory()) {
			String[] children = dir.list();
			for (String element : children) {
				boolean success = deleteDir(new File(dir, element));
				if (!success) {
					return false;
				}
			}
		}

		return dir.delete();
	}

	private Integer obterIdParaExclusaoGed(String strParaVerificar) {
		Integer idParaExclusao = null;

		String[] strParaVerificarArray = strParaVerificar.split("=");

		if (strParaVerificarArray[1] != null) {
			idParaExclusao = Integer.valueOf(strParaVerificarArray[1].toString());
		}

		return idParaExclusao;
	}

	private String definirDiretorioGed(T anexavel) throws Exception {
		String pasta = "";

		if (getGedInterno().equalsIgnoreCase(SimNao.SIM.getValorStr())) {
			pasta = getControleGEDDao().getProximaPastaArmazenar();

			File fileDir = new File(getGedDiretorio());
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}

			fileDir = new File(getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO));
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}

			fileDir = new File(getGedDiretorio().concat(FS).concat(DIRETORIO_PADRAO).concat(FS).concat(pasta));
			if (!fileDir.exists()) {
				fileDir.mkdirs();
			}
		}

		return pasta;
	}

	private String getGedInternoBD() {
		String gedInternoBancoDados = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInternoBD, SimNao.NAO.getValorStr());

		return gedInternoBancoDados;
	}

	private String getGedInterno() {
		String gedInterno = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInterno, SimNao.SIM.getValorStr());

		return gedInterno;
	}

	private String getGedDiretorio() throws Exception {
		String gedDiretorio = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedDiretorio, "");
		if ("".equals(gedDiretorio.trim())) {
			throw new Exception("Diretrio No Informado.");
		}
		return gedDiretorio;
	}

	private boolean isServicoExiste(Integer id) throws PersistenceException {
		Collection<T> colEsquemaDados = findCollectionById(id);
		return (colEsquemaDados != null && !colEsquemaDados.isEmpty()) ? Boolean.TRUE : Boolean.FALSE;
	}

	private ControleGEDDao getControleGEDDao() {
		if (controleGEDDao == null) {
			controleGEDDao = new ControleGEDDao();
		}

		return controleGEDDao;
	}

}
