package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioBusinessUserDTO;
import br.com.centralit.citcorpore.integracao.GerenciamentoPortfolioBusinessUserDao;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class GerenciamentoPortfolioBusinessUserServiceEjb extends CrudServiceImpl implements GerenciamentoPortfolioBusinessUserService {

	private GerenciamentoPortfolioBusinessUserDao dao;

	@Override
	protected GerenciamentoPortfolioBusinessUserDao getDao() {
		if (dao == null) {
			dao = new GerenciamentoPortfolioBusinessUserDao();
		}
		return dao;
	}

	@Override
	public boolean create(List<GerenciamentoPortfolioBusinessUserDTO> lista) throws ServiceException, LogicException {
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		getDao().setTransactionControler(tc);

		try {
			tc.start();

			for (GerenciamentoPortfolioBusinessUserDTO dto : lista) {
				validaCreate(dto);
				getDao().create(dto);
			}

			tc.commit();
		} catch (final Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(tc, e);
		} finally {
			try {
				tc.close();
				return true;
			} catch (final PersistenceException e) {
				e.printStackTrace();
			}
		}

		return false;
	}

	@Override
	public Collection<GerenciamentoPortfolioBusinessUserDTO> listByServico(Integer idServico) throws PersistenceException {
		return this.getDao().listByServico(idServico);
	}

	@Override
	public Collection<GerenciamentoPortfolioBusinessUserDTO> listByServicoAndText(Integer idServico, String text) throws PersistenceException {
		return this.getDao().listByServicoAndText(idServico, text);
	}

}
