package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioHabilidadeDTO;
import br.com.centralit.citcorpore.integracao.GerenciamentoPortfolioHabilidadeDao;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class GerenciamentoPortfolioHabilidadeServiceEjb extends CrudServiceImpl implements GerenciamentoPortfolioHabilidadeService {

	private GerenciamentoPortfolioHabilidadeDao gerenciamentoPortfolioHabilidadeDao;

	@Override
	protected GerenciamentoPortfolioHabilidadeDao getDao() {
		if (gerenciamentoPortfolioHabilidadeDao == null) {
			gerenciamentoPortfolioHabilidadeDao = new GerenciamentoPortfolioHabilidadeDao();
		}
		return gerenciamentoPortfolioHabilidadeDao;
	}

	@Override
	public Collection<GerenciamentoPortfolioHabilidadeDTO> getListHabilidadesByIdServico(GerenciamentoPortfolioHabilidadeDTO habilidadeDTO) throws PersistenceException {
		Collection<GerenciamentoPortfolioHabilidadeDTO> listaHabilidades = this.getDao().getListHabilidadesByIdServico(habilidadeDTO);
		if (listaHabilidades == null || listaHabilidades.isEmpty()) {
			listaHabilidades = new ArrayList<GerenciamentoPortfolioHabilidadeDTO>();
		}
		return listaHabilidades;
	}

	@Override
	public void deleteAllVinculosHabilidades(Integer idServico) throws PersistenceException {
		this.getDao().deleteAllVinculosHabilidade(idServico);
	}

	@Override
	public void deleteByIdHabilidadeVinculo(Integer idHabilidadeVinculo) throws PersistenceException {
		this.getDao().deleteByIdHabilidadeVinculo(idHabilidadeVinculo);
	}

	@Override
	public Collection<GerenciamentoPortfolioHabilidadeDTO> getListHabilidadesFiltradas(GerenciamentoPortfolioHabilidadeDTO habilidadeDTO, String filtro) throws PersistenceException {
		Collection<GerenciamentoPortfolioHabilidadeDTO> listaHabilidades = this.getDao().listHabilidadeByFiltro(habilidadeDTO, filtro);

		if (listaHabilidades == null || listaHabilidades.isEmpty()) {
			listaHabilidades = new ArrayList<GerenciamentoPortfolioHabilidadeDTO>();
		}

		return listaHabilidades;
	}

}
