package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

@SuppressWarnings("rawtypes")
public interface GrupoService extends CrudService {

    /**
	 * Retorna lista de GRUPO que ainda no est�o associados a EMPREGADOS.
	 *
	 * @return
	 * @throws Exception
	 */
    Collection listaGrupoEmpregado() throws Exception;

    /**
	 * Retorna lista de GRUPO que ainda no est�o associados a USU�RIO.
	 *
	 * @return
	 * @throws Exception
	 */
    Collection listaGrupoUsuario() throws Exception;

    Collection getGruposByPessoa(Integer idEmpregado) throws LogicException, ServiceException;

	Collection<GrupoDTO> getGruposByEmpregado(Integer idEmpregado) throws LogicException, ServiceException;

    Collection<GrupoDTO> listGruposServiceDesk() throws Exception;

    IDto create(IDto model, HttpServletRequest request) throws ServiceException, LogicException;

    void update(IDto grupoDto, HttpServletRequest request) throws ServiceException, LogicException;

    void delete(IDto model, DocumentHTML document) throws ServiceException, LogicException;

    Collection<GrupoDTO> listGruposPorUsuario(int idUsuario);

	Collection<GrupoDTO> findGruposAtivos();

    /**
	 * Verifica se grupo informado j existe;
	 *
	 * @param grupo
	 * @return true - existe; false - no existe;
	 * @throws PersistenceException
	 */
    boolean verificarSeGrupoExiste(GrupoDTO grupo) throws PersistenceException;

    Collection<GrupoDTO> listGrupoByIdContrato(Integer idContrato) throws Exception;

    Collection<GrupoDTO> listGrupoAtivosByIdContrato(Integer idContrato) throws Exception;

    Collection<GrupoDTO> listGruposServiceDeskByIdContrato(Integer idContratoParm) throws Exception;

    /**
     * Retorna Lista de Grupos do Empregado.
     *
     * @param idEmpregado
     *            - Identificador do Empregado.
     * @return Collection<GrupoDTO> - Lista de Grupos.
     * @throws Exception
     */
    Collection<GrupoDTO> getGruposByIdEmpregado(Integer idEmpregado) throws Exception;

    Collection listarGruposAtivos() throws Exception;

    /**
	 * Retorna lista de e-mails que esto cadastrados para receber notificao
	 *
	 * @param idGrupo
	 * @return
	 * @throws Exception
	 */
    Collection<String> listarEmailsPorGrupo(Integer idGrupo) throws Exception;

    Collection<String> listarPessoasEmailPorGrupo(Integer idGrupo) throws Exception;

    /**
	 * Retorna lista de GRUPO que so do Comite de Controle de Mudana
	 *
	 * @author Riubbe Oliveira
	 *
	 */
    Collection<GrupoDTO> listGruposComite() throws Exception;

    /**
	 * Retorna lista de GRUPO que no so do Comite de Controle de Mudana
	 *
	 * @author Riubbe Oliveira
	 *
	 */
    Collection<GrupoDTO> listGruposNaoComite() throws Exception;

    /**
     * @param idGrupo
     * @return
     * @throws Exception
     */
    GrupoDTO listGrupoById(Integer idGrupo) throws Exception;

    Collection<GrupoDTO> listAllGrupos() throws Exception;

    /**
     * Retorna uma lista de grupos ativos
     *
     * @return
     * @throws Exception
     * @author thays.araujo
     */
    Collection<GrupoDTO> listaGruposAtivos() throws Exception;

    Collection<GrupoDTO> listaGrupoEmpregado(Integer idEmpregado) throws Exception;

    GrupoDTO restoreBySigla(String sigla) throws PersistenceException;

	Collection getGruposByLiderEmpregado(Integer idLiderEmpregado) throws LogicException, ServiceException;

	GrupoDTO restoreBySigla(GrupoDTO grupoDto) throws PersistenceException;

}
