/**
 * 
 */
package br.com.centralit.citcorpore.negocio;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.HistoricoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudService;

/**
 * @author Vadoilo Damasceno
 * 
 */
public interface HistoricoBaseConhecimentoService extends CrudService {

	/**
	 * Retorna uma lista de historico de alterao de uma base de conhecimento informada
	 * 
	 * @param historicoBaseConhecimentoDto
	 * @return
	 * @throws Exception
	 * @author thays.araujo
	 */
	public Collection<HistoricoBaseConhecimentoDTO> obterHistoricoDeAlteracao(String titulo) throws Exception;
	
	public Collection<HistoricoBaseConhecimentoDTO> obterHistoricoDeAlteracaoPorPeriodo(HistoricoBaseConhecimentoDTO historicoBaseConhecimentoDTO) throws Exception;
	
	public HistoricoBaseConhecimentoDTO restoreHistoricoFromIdBaseConhecimento(HistoricoBaseConhecimentoDTO historicoBaseConhecimentoDTO) throws Exception;
	
	public Collection<HistoricoBaseConhecimentoDTO> getHistoricoDeVersoes(BaseConhecimentoDTO baseConhecimento) throws PersistenceException;
	
	public ArrayList<HistoricoBaseConhecimentoDTO> listHistoricoBaseConhecimento(final Date dtInicio, final Date dtFim, final Integer idPasta, final String hierarquizarPasta, final Integer tipoFiltro, final UsuarioDTO usuario);

}