/**
 *
 */
package br.com.centralit.citcorpore.negocio;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.HistoricoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.HistoricoBaseConhecimentoDAO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudServiceImpl;

/**
 * @author Vadoilo Damasceno
 *
 */
public class HistoricoBaseConhecimentoServiceEjb extends CrudServiceImpl implements HistoricoBaseConhecimentoService {

    private HistoricoBaseConhecimentoDAO dao;

    @Override
    protected HistoricoBaseConhecimentoDAO getDao() {
        if (dao == null) {
            dao = new HistoricoBaseConhecimentoDAO();
        }
        return dao;
    }

    @Override
	public Collection<HistoricoBaseConhecimentoDTO> obterHistoricoDeAlteracao(final String titulo) throws Exception {
		Collection<HistoricoBaseConhecimentoDTO> preResult = this.getDao().obterHistoricoDeAlteracao(titulo);
		Collection<HistoricoBaseConhecimentoDTO> result = new ArrayList<HistoricoBaseConhecimentoDTO>();

		if (preResult != null && titulo != null) {
			for (HistoricoBaseConhecimentoDTO historico : preResult) {
				if (historico.getTitulo().length() >= titulo.length()) {
					String[] aux = titulo.split(" - v[\\d]+.[\\d]+");
					if (aux != null && aux.length > 0 && historico.getTitulo().contains(aux[0])) {
						result.add(historico);
					}
				}
			}
		}
		return result;
    }

    @Override
    public Collection<HistoricoBaseConhecimentoDTO> obterHistoricoDeAlteracaoPorPeriodo(final HistoricoBaseConhecimentoDTO historicoBaseConhecimentoDTO) throws Exception {
        Collection<HistoricoBaseConhecimentoDTO> listaHistoricoBaseConhecimentoDTOs = null;
        try {
            listaHistoricoBaseConhecimentoDTOs = this.getDao().list();
        } catch (final Exception e) {
            e.printStackTrace();
        }
        return listaHistoricoBaseConhecimentoDTOs;
    }

	@Override
	public HistoricoBaseConhecimentoDTO restoreHistoricoFromIdBaseConhecimento(HistoricoBaseConhecimentoDTO historicoBaseConhecimentoDTO) throws Exception {
		if(historicoBaseConhecimentoDTO != null && historicoBaseConhecimentoDTO.getIdBaseConhecimento() != null){
			Collection<HistoricoBaseConhecimentoDTO> colHistoricoBaseConhecimentoDTO = getDao().restoreHistoricoFromIdBaseConhecimento(historicoBaseConhecimentoDTO);
			if(colHistoricoBaseConhecimentoDTO != null && colHistoricoBaseConhecimentoDTO.size() > 0){
				List<HistoricoBaseConhecimentoDTO> listHistorico = new ArrayList<>(colHistoricoBaseConhecimentoDTO);
				return listHistorico.get(0);
			}
		}
		return new HistoricoBaseConhecimentoDTO();
	}
	
	@Override
	public Collection<HistoricoBaseConhecimentoDTO> getHistoricoDeVersoes(BaseConhecimentoDTO baseConhecimento) throws PersistenceException {
		Collection<HistoricoBaseConhecimentoDTO> preResult = this.getDao().getHistoricoDeVersoes(baseConhecimento);
		Collection<HistoricoBaseConhecimentoDTO> result = new ArrayList<HistoricoBaseConhecimentoDTO>();
		
		if (preResult != null) {
			for (HistoricoBaseConhecimentoDTO historico : preResult) {
				if (historico.getTitulo().length() >= baseConhecimento.getTitulo().length()) {
					String[] aux = baseConhecimento.getTitulo().split(" - v[\\d]+.[\\d]+");
					if (aux != null && aux.length > 0 && historico.getTitulo().contains(aux[0])) {
						result.add(historico);
					}
				}
			}
		}
		return result;
	}
	
	public ArrayList<HistoricoBaseConhecimentoDTO> listHistoricoBaseConhecimento(final Date dtInicio, final Date dtFim, final Integer idPasta, final String hierarquizarPasta, final Integer tipoFiltro, final UsuarioDTO usuario) {
		return this.getDao().listHistoricoBaseConhecimento(dtInicio, dtFim, idPasta, hierarquizarPasta, tipoFiltro, usuario);
	}

}