package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.HistoricoServicoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudService;

public interface HistoricoServicoService extends CrudService {

	public Collection findByIdServico(Integer parm) throws PersistenceException;

	public Collection findByIdCategoriaServico(Integer parm) throws PersistenceException;

	public void deleteByIdCategoriaServico(Integer parm) throws PersistenceException;

	public Collection findByIdSituacaoServico(Integer parm) throws PersistenceException;

	public void deleteByIdSituacaoServico(Integer parm) throws PersistenceException;

	public Collection findByIdTipoDemandaAndIdCategoria(Integer idTipoDemanda, Integer idCategoria) throws PersistenceException;

	public Collection findByIdTipoDemandaAndIdContrato(Integer idTipoDemanda, Integer idContrato, Integer idCategoria) throws PersistenceException;

	public String retornaSiglaPorIdOs(Integer idOs) throws PersistenceException;

	public Collection findByNome(HistoricoServicoDTO servicoDTO) throws PersistenceException;

	public Collection findByIdServicoAndIdTipoDemandaAndIdCategoria(Integer idServico, Integer idTipoDemanda, Integer idCategoria) throws PersistenceException;

	public HistoricoServicoDTO restoreByIdServico(Integer idServico);

	public Collection<HistoricoServicoDTO> findByServico(Integer idServico) throws PersistenceException;

	public Collection<HistoricoServicoDTO> findByServico(Integer idServico, String nome) throws PersistenceException;
}
