package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.HistoricoServicoDTO;
import br.com.centralit.citcorpore.integracao.HistoricoServicoDao;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings({ "unchecked" })
public class HistoricoServicoServiceEjb extends CrudServiceImpl implements HistoricoServicoService {

	private HistoricoServicoDao historicoServicoDao;

	@Override
	protected HistoricoServicoDao getDao() {
		if (historicoServicoDao == null) {
			historicoServicoDao = new HistoricoServicoDao();
		}
		return historicoServicoDao;
	}

	@Override
	public Collection findByIdServico(Integer parm) throws PersistenceException {
		return getDao().findByIdServico(parm);
	}

	@Override
	public Collection findByIdCategoriaServico(Integer parm) throws PersistenceException {
		return getDao().findByIdCategoriaServico(parm);
	}

	@Override
	public void deleteByIdCategoriaServico(Integer parm) throws PersistenceException {
		getDao().deleteByIdCategoriaServico(parm);
	}

	@Override
	public Collection findByIdSituacaoServico(Integer parm) throws PersistenceException {
		return getDao().findByIdSituacaoServico(parm);
	}

	@Override
	public void deleteByIdSituacaoServico(Integer parm) throws PersistenceException {
		getDao().deleteByIdSituacaoServico(parm);
	}

	@Override
	public Collection findByIdTipoDemandaAndIdCategoria(Integer idTipoDemanda, Integer idCategoria) throws PersistenceException {
		return getDao().findByIdTipoDemandaAndIdCategoria(idTipoDemanda, idCategoria);
	}

	@Override
	public Collection findByIdTipoDemandaAndIdContrato(Integer idTipoDemanda, Integer idContrato, Integer idCategoria) throws PersistenceException {
		return getDao().findByIdTipoDemandaAndIdContrato(idTipoDemanda, idCategoria, idCategoria);
	}

	@Override
	public String retornaSiglaPorIdOs(Integer idOs) throws PersistenceException {
		return getDao().retornaSiglaPorIdOs(idOs);
	}

	@Override
	public Collection findByNome(HistoricoServicoDTO servicoDTO) throws PersistenceException {
		return getDao().findByNome(servicoDTO);
	}

	@Override
	public Collection findByIdServicoAndIdTipoDemandaAndIdCategoria(Integer idServico, Integer idTipoDemanda, Integer idCategoria) throws PersistenceException {
		return getDao().findByIdServicoAndIdTipoDemandaAndIdCategoria(idServico, idTipoDemanda, idCategoria);
	}

	@Override
	public HistoricoServicoDTO restoreByIdServico(Integer idServico) {
		return getDao().restoreByIdServico(idServico);
	}

	@Override
	public Collection<HistoricoServicoDTO> findByServico(Integer idServico) throws PersistenceException {
		return getDao().findByServico(idServico);
	}

	@Override
	public Collection<HistoricoServicoDTO> findByServico(Integer idServico, String nome) throws PersistenceException {
		return getDao().findByServico(idServico, nome);
	}

}