package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.HistoricoSolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.RelatorioCargaHorariaDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.integracao.HistoricoSolicitacaoServicoDao;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings("unchecked")
public class HistoricoSolicitacaoServicoServiceEjb extends CrudServiceImpl implements HistoricoSolicitacaoServicoService {

    private HistoricoSolicitacaoServicoDao dao;
    private HistoricoSolicitacaoServicoDao daoReports;

    @Override
    protected HistoricoSolicitacaoServicoDao getDao() {
        if (dao == null) {
            dao = new HistoricoSolicitacaoServicoDao();
        }
        return dao;
    }

	/**
	 * Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 14:40 - ID Citsmart: 176362 -
	 * Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
	 * @param databaseAlias
	 * @return dao com o databaseAlias especificado, caso esteja preenchido, seno dao com o datasource principal
	 */
	private HistoricoSolicitacaoServicoDao getDao(String databaseAlias) {
		if (UtilStrings.isNotVazio(databaseAlias)) {
			if (daoReports == null) {
				daoReports = new HistoricoSolicitacaoServicoDao(databaseAlias);
			}
			return daoReports;
		}
		return this.getDao();
	}
    
    @Override
    public boolean findHistoricoSolicitacao(final Integer idSolicitacaoServico) throws Exception {
        return this.getDao().findHistoricoSolicitacao(idSolicitacaoServico);
    }

    @Override
    public Collection<HistoricoSolicitacaoServicoDTO> restoreHistoricoServico(final Integer idSolicitacaoServico) throws Exception {
        return this.getDao().restoreHistoricoServico(idSolicitacaoServico);
    }

    @Override
    public Collection<HistoricoSolicitacaoServicoDTO> findResponsavelAtual(final Integer idSolicitacaoServico) throws Exception {
        return this.getDao().findResponsavelAtual(idSolicitacaoServico);
    }

    @Override
    public Collection<RelatorioCargaHorariaDTO> imprimirCargaHorariaUsuario(final SolicitacaoServicoDTO solicitacaoServicoDTO) throws Exception {
    	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 14:40 - ID Citsmart: 176362 -
   	 	// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).imprimirCargaHorariaUsuario(solicitacaoServicoDTO);
    }

    @Override
    public Collection<SolicitacaoServicoDTO> imprimirSolicitacaoEncaminhada(final SolicitacaoServicoDTO solicitacaoServicoDTO) throws Exception {
   	 	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 14:40 - ID Citsmart: 176362 -
   	 	// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
    	return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).imprimirSolicitacaoEncaminhada(solicitacaoServicoDTO);
    }

    @Override
    public Collection<SolicitacaoServicoDTO> imprimirSolicitacaoEncaminhadaFilhas(final SolicitacaoServicoDTO solicitacaoServicoDTO) throws Exception {
    	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 14:40 - ID Citsmart: 176362 -
   	 	// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).imprimirSolicitacaoEncaminhadaFilhas(solicitacaoServicoDTO);
    }

    @Override
    public Collection<RelatorioCargaHorariaDTO> imprimirCargaHorariaGrupo(final SolicitacaoServicoDTO solicitacaoServicoDTO) throws Exception {
    	// Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 14:40 - ID Citsmart: 176362 -
   	 	// Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).imprimirCargaHorariaGrupo(solicitacaoServicoDTO);
    }

    public static IDto create(final HistoricoSolicitacaoServicoDTO historicoSolicitacaoServicoDTO, final TransactionControler tc) throws Exception {
        IDto historico = new HistoricoSolicitacaoServicoDTO();
        final HistoricoSolicitacaoServicoDao historicoSolicitacaoServicoDao = new HistoricoSolicitacaoServicoDao();
        if (tc != null) {
            historicoSolicitacaoServicoDao.setTransactionControler(tc);
            historico = historicoSolicitacaoServicoDao.create(historicoSolicitacaoServicoDTO);
        }
        return historico;
    }

    public static void update(final HistoricoSolicitacaoServicoDTO historicoSolicitacaoServicoDTO, final TransactionControler tc) throws Exception {
        final HistoricoSolicitacaoServicoDao historicoSolicitacaoServicoDao = new HistoricoSolicitacaoServicoDao();
        if (tc != null) {
            historicoSolicitacaoServicoDao.setTransactionControler(tc);
            historicoSolicitacaoServicoDao.update(historicoSolicitacaoServicoDTO);
        }
    }

}
