package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.ImportanciaNegocioDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

public interface ImportanciaNegocioService extends CrudService {
	boolean existeRegistro(String nome);
	
	/**
	 * Metodo reponsavel por verificar se existe um vinculo entre Inmportancia Negocio e Cadastro de Servio
	 * 
	 * @param idImportanciaNegocio
	 * @author Ezequiel
	 * @date 2014-11-25
	 */
	void existeVinculoCadastroServico(final Integer idImportanciaNegocio) throws PersistenceException, ServiceException, Exception;

	/**
	 * Metodo reponsavel por buscar as importancias do negocio que esto ativos
	 * 
	 * @author rodrigo.guilherme
	 * @date 2015-08-20
	 */
	public Collection<ImportanciaNegocioDTO> getAtivos() throws PersistenceException, Exception;
}
