package br.com.centralit.citcorpore.negocio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import br.com.centralit.citcorpore.bean.AtributosFinanceirosDTO;
import br.com.centralit.citcorpore.bean.CadastroTipoFinanceiroDTO;
import br.com.centralit.citcorpore.integracao.AtributosFinanceirosDao;
import br.com.centralit.citcorpore.integracao.CadastroTipoFinanceiroDao;
import br.com.citframework.integracao.CrudDAO;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings({"unchecked","rawtypes"})
public class ImportarAtributosFinanceirosServiceEjb extends CrudServiceImpl implements ImportarAtributosFinanceirosService {

	private AtributosFinanceirosDao atributosFinanceirosDao;
	
	@Override
	public Collection<AtributosFinanceirosDTO> gerarCargaXml(File carga, Integer idServico) throws Exception {
		
		DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
		Document doc = dBuilder.parse(carga);
		doc.getDocumentElement().normalize();

		NodeList nList = doc.getElementsByTagName("AtributosFinanceirosDTO");
		List<AtributosFinanceirosDTO> listAtributosFinanceiros = new ArrayList();
			for (int temp = 0; temp < nList.getLength(); temp++) {
				try{
					Node nNode = nList.item(temp);
					if (nNode.getNodeType() == Node.ELEMENT_NODE) {
							Element eElement = (Element) nNode;
							AtributosFinanceirosDTO atributosFinanceirosDTO = new AtributosFinanceirosDTO();
							Double valor = getDoubleFromElement((Element) nNode, "valor");
							Integer idClassificacao = getIntegerFromElement((Element) nNode, "idClassificacao");
							String nomeCategoria = eElement.getElementsByTagName("nomeCategoria").item(0).getTextContent();
							if(nomeCategoria.isEmpty())
								continue;
							String tipo = eElement.getElementsByTagName("tipo").item(0).getTextContent().toString();
							if(valor == null || nomeCategoria == null)
								continue;
							atributosFinanceirosDTO.setIdServico(idServico);
							atributosFinanceirosDTO.setValor(valor);
							atributosFinanceirosDTO.setTipo(tipo);
							atributosFinanceirosDTO.setIdClassificacao(idClassificacao);
							atributosFinanceirosDTO.setNomeCategoria(nomeCategoria);
							listAtributosFinanceiros.add(atributosFinanceirosDTO);
					}
				} catch (Exception e){ e.printStackTrace();}

			}
		
		return listAtributosFinanceiros;
	}
	
	@Override
	public Collection<AtributosFinanceirosDTO> gerarCargaXls(File carga, Integer idServico) throws Exception {
		POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(carga));
		HSSFWorkbook wb = new HSSFWorkbook(fs);
		HSSFSheet sheet = wb.getSheetAt(0);
		HSSFRow row;

		int rows; 
		rows = sheet.getPhysicalNumberOfRows();

		List<AtributosFinanceirosDTO> listAtributosFinanceiros = new ArrayList();
		for (int r = 0; r < rows; r++) {
			try{
				row = sheet.getRow(r);
				if (row != null) {
					AtributosFinanceirosDTO atributosFinanceirosDTO = new AtributosFinanceirosDTO();
					String nomeCategoria = row.getCell(0).getStringCellValue();
					if(nomeCategoria.isEmpty())
						continue;
					String tipo = row.getCell(1).getStringCellValue();
					Integer idClassificacao = row.getCell(2) != null ? new Double(row.getCell(2).getNumericCellValue()).intValue() : null;
					Double valor = row.getCell(3).getNumericCellValue();
					if(valor == null || nomeCategoria == null)
						continue;
					atributosFinanceirosDTO.setIdServico(idServico);
					atributosFinanceirosDTO.setValor(valor);
					atributosFinanceirosDTO.setTipo(tipo);
					atributosFinanceirosDTO.setIdClassificacao(idClassificacao);
					atributosFinanceirosDTO.setNomeCategoria(nomeCategoria);
					listAtributosFinanceiros.add(atributosFinanceirosDTO);
				}
			} catch (Exception e){e.printStackTrace();}
		}
		return listAtributosFinanceiros;
	}
	
	@Override
	public Collection<AtributosFinanceirosDTO> gerarCargaXlsx(File carga, Integer idServico) throws Exception {
		XSSFWorkbook wb = new XSSFWorkbook(new FileInputStream(carga));
		XSSFSheet sheet = wb.getSheetAt(0);
		XSSFRow row;

		int rows; 
		rows = sheet.getPhysicalNumberOfRows();

		List<AtributosFinanceirosDTO> listAtributosFinanceiros = new ArrayList();
		for (int r = 0; r < rows; r++) {
			try{
				row = sheet.getRow(r);
				if (row != null) {
					AtributosFinanceirosDTO atributosFinanceirosDTO = new AtributosFinanceirosDTO();
					String nomeCategoria = row.getCell(0).getStringCellValue();
					if(nomeCategoria.isEmpty())
						continue;
					String tipo = row.getCell(1).getStringCellValue();
					Integer idClassificacao = row.getCell(2) != null ? new Double(row.getCell(2).getNumericCellValue()).intValue() : null;
					Double valor = row.getCell(3).getNumericCellValue();
					if(valor == null || nomeCategoria == null)
						continue;
					atributosFinanceirosDTO.setIdServico(idServico);
					atributosFinanceirosDTO.setValor(valor);
					atributosFinanceirosDTO.setTipo(tipo);
					atributosFinanceirosDTO.setIdClassificacao(idClassificacao);
					atributosFinanceirosDTO.setNomeCategoria(nomeCategoria);
					listAtributosFinanceiros.add(atributosFinanceirosDTO);
				}
			} catch (Exception e){e.printStackTrace();}
		}
		return listAtributosFinanceiros;
	}
	
	@Override
	public Collection<AtributosFinanceirosDTO> gerarCargaCsv(File carga, Integer idServico) throws Exception {
		BufferedReader br = null;
		String line = "";
		String cvsSplitBy = ";";
		List<AtributosFinanceirosDTO> listAtributosFinanceiros = new ArrayList();
		try {
			br = new BufferedReader(new FileReader(carga));
			while ((line = br.readLine()) != null) {
				try{
					String[] tuple = line.split(cvsSplitBy);
					AtributosFinanceirosDTO atributosFinanceirosDTO = new AtributosFinanceirosDTO();
					String nomeCategoria = tuple[0];
					if(nomeCategoria.isEmpty())
						continue;
					String tipo = tuple[1];
					Integer idClassificacao = getIntegerFromString(tuple[2]);
					Double valor = getDoubleFromString(tuple[3]);
					if(valor == null || nomeCategoria == null)
						continue;
					atributosFinanceirosDTO.setIdServico(idServico);
					atributosFinanceirosDTO.setValor(valor);
					atributosFinanceirosDTO.setTipo(tipo);
					atributosFinanceirosDTO.setIdClassificacao(idClassificacao);
					atributosFinanceirosDTO.setNomeCategoria(nomeCategoria);
					listAtributosFinanceiros.add(atributosFinanceirosDTO);
				}catch (Exception e){e.printStackTrace();}
			} 
		}
		catch(Exception e){
			e.printStackTrace();
		} finally {
			br.close();
		}
		return listAtributosFinanceiros;
	}
	
	public boolean gravaListAtributosFinanceiros(Collection<AtributosFinanceirosDTO> listAtributosFinanceiros) throws Exception {
		if(listAtributosFinanceiros.isEmpty()){
			return false;
		}
		TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		AtributosFinanceirosDao atributosFinanceirosDao = new AtributosFinanceirosDao();
		CadastroTipoFinanceiroDao cadastroTipoFinanceiroDao = new CadastroTipoFinanceiroDao();
		Map<String, Integer> mapTipoCategoria = cadastroTipoFinanceiroDao.getSetNomeCategoria();
		try{
			atributosFinanceirosDao.setTransactionControler(tc);
			cadastroTipoFinanceiroDao.setTransactionControler(tc);
			tc.start();
			for(AtributosFinanceirosDTO atributosFinanceirosDTO : listAtributosFinanceiros){
				Integer idTipo = null;
				if(!mapTipoCategoria.containsKey(atributosFinanceirosDTO.getNomeCategoria())){
					CadastroTipoFinanceiroDTO cadastroTipoFinanceiroDTO = new CadastroTipoFinanceiroDTO();
					cadastroTipoFinanceiroDTO.setNomeTipo(atributosFinanceirosDTO.getNomeCategoria());
					cadastroTipoFinanceiroDTO.setPerfil(atributosFinanceirosDTO.getTipo().toUpperCase());
					cadastroTipoFinanceiroDTO.setClassificacaoTipo(atributosFinanceirosDTO.getIdClassificacao());
					cadastroTipoFinanceiroDTO = (CadastroTipoFinanceiroDTO) cadastroTipoFinanceiroDao.create(cadastroTipoFinanceiroDTO);
					idTipo = cadastroTipoFinanceiroDTO.getIdTipo();
				} else {
					idTipo = mapTipoCategoria.get(atributosFinanceirosDTO.getNomeCategoria());
				}
				if(idTipo == null)
					continue;
				atributosFinanceirosDTO.setIdTipo(idTipo);
				atributosFinanceirosDao.create(atributosFinanceirosDTO);
			}
			tc.commit();
		} catch (Exception e){
			e.printStackTrace();
			tc.rollback();
			return false;
		} finally {
			tc.closeQuietly();
		}
		return true;
	}

	@Override
	protected CrudDAO getDao() {
		if(atributosFinanceirosDao == null)
			atributosFinanceirosDao = new AtributosFinanceirosDao();
		return atributosFinanceirosDao;
	}
	
	private Double getDoubleFromElement(Element e, String key){ 
		try{
			return getDoubleFromString(e.getElementsByTagName(key).item(0).getTextContent());
		} catch (Exception ex){
			return null;
		}
	}
	
	private Double getDoubleFromString(String text){
		try{
			return Double.valueOf(text.replaceAll(",", "."));
		} catch (Exception e){
			return null;
		}
	}
	
	private Integer getIntegerFromElement(Element e, String key){
		try{
			return getIntegerFromString(e.getElementsByTagName(key).item(0).getTextContent());
		} catch (Exception ex){
			return null;
		}
	}
	
	private Integer getIntegerFromString(String text){
		try{
			return Integer.valueOf(text);
		} catch (Exception e){
			return null;
		}
	}

}
