package br.com.centralit.citcorpore.negocio;

import java.io.File;
import java.util.Collection;
import java.util.Map;

import br.com.centralit.citcorpore.bean.AtributosFinanceirosDTO;
import br.com.citframework.service.CrudService;

/**
 * Classe utilizada para importar arquivos no formato ATRIBUTO ; VALOR.<br />
 * Qualquer coluna/atributo alm disto ser ignorado.<br />
 * Qualquer tupla que estiver faltando um destes  desconsiderado.<br />
 * Em .xml, no importar o nome da tag, contando que se mantenha:
 * <br /><br />
 * &lt;objeto&gt;<br />
 *     &lt;atributo&gt;&lt;/atributo&gt;<br />
 *     &lt;valor&gt;&lt;/valor&gt;<br />
 * &lt;/objeto&gt<br/>
 * <br /><br />
 * Formatos de arquivo suportados: XLS, XLSX, XML, CSV.
 * 
 * @author thyen.chang - <a hred="mailto:thyen.chang@centralit.com.br">thyen.chang@centralit.com.br</a>
 * @since 2016.02.26
 */
public interface ImportarDadosArquivoService extends CrudService {

	Map<String, String> getMapaDados(final File carga) throws Exception;
	
}
