package br.com.centralit.citcorpore.negocio;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import br.com.citframework.integracao.CrudDAO;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings({"unchecked","rawtypes"})
public class ImportarDadosArquivoServiceEjb extends CrudServiceImpl implements ImportarDadosArquivoService {

	@Override
	public Map<String, String> getMapaDados(File carga) throws Exception {
		String extensao = br.com.centralit.citcorpore.util.Util.getFileExtension(carga.getName());
		Map<String, String> retorno = null;
        switch(extensao){
        	case "xml":
        		retorno = gerarCargaXml(carga);
        		break;
        	case "xls":
        		retorno = gerarCargaXls(carga);
        		break;
        	case "xlsx":
        		retorno = gerarCargaXlsx(carga);
        		break;
        	case "csv":
        		retorno = gerarCargaCsv(carga);
        		break;
        }
		return retorno;
	}
	
	public Map<String, String> gerarCargaXml(File carga) throws Exception {
		
		DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
		DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
		Document doc = dBuilder.parse(carga);
		doc.getDocumentElement().normalize();
		
		Map<String, String> mapRetorno = new HashMap<>();

		NodeList nList = doc.getChildNodes();
		nList = nList.item(0).getChildNodes(); //Pega elemento da raiz
		for(int i = 0; i < nList.getLength(); i++){
			try{
				Node nNode = nList.item(i);
				if (nNode.getNodeType() == Node.ELEMENT_NODE) {
					NodeList childNodeList = nNode.getChildNodes();
					String nome = null;
					String valor = null;
					for(int j = 0; j < childNodeList.getLength(); j++){
						Node childNode = childNodeList.item(j);
						if(childNode.getNodeType() == Node.ELEMENT_NODE){
							if(nome == null){
								nome = childNode.getTextContent();
							} else {
								valor = childNode.getTextContent();
								break;
							}
						}
					}
					mapRetorno.put(nome, valor);
				}
			} catch (Exception e){ e.printStackTrace();}
		}
		
		return mapRetorno;
	}
	
	public Map<String, String> gerarCargaXls(File carga) throws Exception {
		POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(carga));
		HSSFWorkbook wb = new HSSFWorkbook(fs);
		HSSFSheet sheet = wb.getSheetAt(0);
		HSSFRow row;

		int rows; 
		rows = sheet.getPhysicalNumberOfRows();

		Map<String, String> mapRetorno = new HashMap<>();
		for (int r = 0; r < rows; r++) {
			try{
				row = sheet.getRow(r);
				if (row != null) {
					String atributo = row.getCell(0).toString();
					String valor = row.getCell(1).toString();

					if(row.getCell(1).getCellType() == Cell.CELL_TYPE_NUMERIC) {
						if(valor.endsWith(".0")) {
							valor = valor.replace(".0", "");
						} else if(valor.matches("^[0-9]*\\.[0-9]{1}$")) {
							valor = valor.replace(".", ",") + "0";
						} else if(valor.matches("^[0-9]*\\.[0-9]{1,}$")) {
							valor = valor.replace(".", ",");
						}
					}

					mapRetorno.put(atributo, valor);
				}
			} catch (Exception e){e.printStackTrace();}
		}
		return mapRetorno;
	}
	
	public Map<String, String> gerarCargaXlsx(File carga) throws Exception {
		XSSFWorkbook wb = new XSSFWorkbook(new FileInputStream(carga));
		XSSFSheet sheet = wb.getSheetAt(0);
		XSSFRow row;

		int rows; 
		rows = sheet.getPhysicalNumberOfRows();

		Map<String, String> mapRetorno = new HashMap<>();
		for (int r = 0; r < rows; r++) {
			try{
				row = sheet.getRow(r);
				if (row != null) {
					String atributo = row.getCell(0).toString();
					String valor = row.getCell(1).toString();
					if(row.getCell(1).getCellType() == Cell.CELL_TYPE_NUMERIC) {
						valor = row.getCell(1).getRawValue();
						if(valor.matches("^[0-9]*\\.[0-9]{1}$")) {
							valor = valor.replace(".", ",") + "0";
						} else if(valor.matches("^[0-9]*\\.[0-9]{1,}$")) {
							valor = valor.replace(".", ",");
						}
					}

					mapRetorno.put(atributo, valor);
				}
			} catch (Exception e){e.printStackTrace();}
		}
		return mapRetorno;
	}
	
	public Map<String, String> gerarCargaCsv(File carga) throws Exception {
		BufferedReader br = null;
		String line = "";
		String cvsSplitBy = ";";
		Map<String, String> mapRetorno = new HashMap<>();
		try {
			br = new BufferedReader(new FileReader(carga));
			while ((line = br.readLine()) != null) {
				try{
					String[] tuple = line.split(cvsSplitBy);
					String atributo = tuple[0];
					String valor = tuple[1];
					mapRetorno.put(atributo, valor);
				}catch (Exception e){e.printStackTrace();}
			} 
		}
		catch(Exception e){
			e.printStackTrace();
		} finally {
			br.close();
		}
		return mapRetorno;
	}
	
	@Override
	protected CrudDAO getDao() {
		return null;
	}
	
}
