package br.com.centralit.citcorpore.negocio;

import java.util.List;

import br.com.centralit.citcorpore.bean.GerenciamentoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.IndicadorCapacidadeItemConfiguracaoDTO;
import br.com.centralit.citcorpore.integracao.IndicadorCapacidadeItemConfiguracaoDao;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class IndicadorCapacidadeItemConfiguracaoServiceEjb extends CrudServiceImpl implements IndicadorCapacidadeItemConfiguracaoService {

	
	@Override
	protected IndicadorCapacidadeItemConfiguracaoDao getDao() {
		return new IndicadorCapacidadeItemConfiguracaoDao();
	}

	@Override
	public List<IndicadorCapacidadeItemConfiguracaoDTO> listByIdItemConfiguracao(GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO, Integer pageNo, Integer pageSize) throws Exception{
		return getDao().listByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO, pageNo, pageSize);
	}

	@Override
	public Integer getTotalPaginasIndicadoresCapacidade(Integer pageSize, Integer idItemConfiguracao) throws Exception{
		Double totalItens = new Double(this.getDao().getTotalItensAtributosFinanceiros(idItemConfiguracao));
		Double totalPaginas = Math.ceil(totalItens / new Double(pageSize));
		return totalPaginas.intValue();
	}

	@Override
	public void deleteByIdItemConfiguracao(Integer idItemConfiguracao) throws Exception{
		this.getDao().deleteByIdServico(idItemConfiguracao);
	}

	@Override
	public List<IndicadorCapacidadeItemConfiguracaoDTO> listAllByIdItemConfiguracao(Integer idItemConfiguracao) throws Exception{
		return getDao().listAllByIdServico(idItemConfiguracao);
	}

}
