package br.com.centralit.citcorpore.negocio;

import java.io.File;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citcorpore.bean.IndicadorCapacidadeDTO;
import br.com.centralit.citcorpore.integracao.IndicadorCapacidadeDao;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings("unchecked")
public class IndicadorCapacidadeServiceEjb extends CrudServiceImpl implements IndicadorCapacidadeService {

	private ImportarDadosArquivoService importarDadosArquivoService;
	
	@Override
	protected IndicadorCapacidadeDao getDao() {
		return new IndicadorCapacidadeDao();
	}
	
	private ImportarDadosArquivoService getImportarDadosArquivoService() throws ServiceException{
		if(importarDadosArquivoService == null)
			importarDadosArquivoService = (ImportarDadosArquivoService) ServiceLocator.getInstance().getService(ImportarDadosArquivoService.class, null);
		return importarDadosArquivoService;
	}
	
	@Override
	public String importarDados(File carga, HttpServletRequest request) throws Exception {
		Map<String, String> mapDados = getImportarDadosArquivoService().getMapaDados(carga);
		if(mapDados == null || mapDados.isEmpty())
			return "importaratributofinanceiro.falhaimportacao";
		for(String key : mapDados.keySet()){
			try{
				IndicadorCapacidadeDTO indicadorCapacidadeDTO = new IndicadorCapacidadeDTO();
				if(!key.isEmpty() && mapDados.get(key) != null && !mapDados.get(key).isEmpty() 
						&& (!mapDados.get(key).equals(UtilI18N.internacionaliza(request, "importaratributosfinanceiros.valor")) && !key.equals(UtilI18N.internacionaliza(request, "importaratributosfinanceiros.nomeAtributo")))){
					indicadorCapacidadeDTO.setNome(key);
					indicadorCapacidadeDTO.setValor(mapDados.get(key));
					this.create(indicadorCapacidadeDTO);
				}
			} catch (Exception e){e.printStackTrace();}
		}
		return "importaratributofinanceiro.sucesso";
	}

	@Override
	public void delete(IDto model) throws ServiceException, LogicException {
		IndicadorCapacidadeDTO indicadorCapacidadeDTO = (IndicadorCapacidadeDTO) this.restore(model);
		indicadorCapacidadeDTO.setDataHoraFim(UtilDatas.getDataHoraAtual());
		this.update(indicadorCapacidadeDTO);
	}
	
}
