package br.com.centralit.citcorpore.negocio;

import java.util.List;

import br.com.centralit.citcorpore.bean.IndicadorCapacidadeServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoNegocioIndicadorCapacidadeDTO;
import br.com.centralit.citcorpore.integracao.IndicadorCapacidadeServicoDao;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class IndicadorCapacidadeServicoServiceEjb extends CrudServiceImpl implements IndicadorCapacidadeServicoService {

	
	@Override
	protected IndicadorCapacidadeServicoDao getDao() {
		return new IndicadorCapacidadeServicoDao();
	}

	@Override
	public List<IndicadorCapacidadeServicoDTO> listByIdServico(ServicoNegocioIndicadorCapacidadeDTO servicoNegocioIndicadorCapacidadeDTO, Integer pageNo, Integer pageSize) throws Exception{
		return getDao().listByIdServico(servicoNegocioIndicadorCapacidadeDTO, pageNo, pageSize);
	}

	@Override
	public Integer getTotalPaginasIndicadoresCapacidade(Integer pageSize, Integer idServico) throws Exception{
		Double totalItens = new Double(this.getDao().getTotalItensAtributosFinanceiros(idServico));
		Double totalPaginas = Math.ceil(totalItens / new Double(pageSize));
		return totalPaginas.intValue();
	}

	@Override
	public void deleteByIdServico(Integer idServico) throws Exception {
		this.getDao().deleteByIdServico(idServico);
	}

	@Override
	public List<IndicadorCapacidadeServicoDTO> listAllByIdServico(Integer idServico) throws Exception {
		return getDao().listAllByIdServico(idServico);
	}

}
