package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.IntegranteViagemDTO;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

public interface IntegranteViagemService extends CrudService{

	public IntegranteViagemDTO findById(Integer idIntegranteViagem) throws Exception;

	public Collection<IntegranteViagemDTO> findAllRemarcacaoByIdSolicitacao(Integer idSolicitacaoServico);
	public Collection<IntegranteViagemDTO> recuperaIntegrantesPrestacaoContas(IntegranteViagemDTO integranteViagemDTO, String eOu) throws Exception;


	/**
	 * TODO Este metodo esta em desuso, pode ser removido na proxima verso
	 */
	public Collection<IntegranteViagemDTO> recuperaIntegrantesRemarcacao(IntegranteViagemDTO integranteViagemDTO, String eOu) throws Exception;
	public Collection<IntegranteViagemDTO> recuperaIntegrantesAdiantamento(IntegranteViagemDTO integranteViagemDTO, String eOu) throws Exception;

	/**
	 * TODO Este metodo esta em desuso, pode ser removido na proxima verso
	 */
	public Collection<IntegranteViagemDTO> recuperaIntegrantesViagemByIdSolicitacao(Integer idSolicitacaoServico) throws Exception;
	public Collection<IntegranteViagemDTO> recuperaIntegrantesViagemByIdSolicitacaoEstado(Integer idSolicitacao, String estado) throws Exception;
	public IntegranteViagemDTO getIntegranteByIdSolicitacaoAndTarefa(Integer idsolicitacaoServico, Integer idTarefa) throws Exception;

	public Collection<IntegranteViagemDTO> recuperaIntegrantesByIdResponsavel(IntegranteViagemDTO integranteViagemDTO, String eOu) throws Exception;

	/**
	 * Expira a prestao de contas pendente
	 *
	 * @author renato.jesus
	 * @param integranteViagemDTO
	 *
     * @throws ServiceException
     * @throws LogicException
     * @throws PersistenceException
     *
	 */
	public void expiraPrestacaoContasPendente(IntegranteViagemDTO integranteViagemDTO) throws ServiceException, LogicException, PersistenceException;
	
	/**
	 * Retonar todos os integrantes que prestaram contas de uma viagem
	 * 
	 * @author renato.jesus
	 * 
	 * @return Collection<IntegranteViagemDTO>
	 * 
	 * @throws PersistenceException
	 */
	public Collection<IntegranteViagemDTO> findAllIntegrantesViagemPrestouContas(IntegranteViagemDTO integranteViagemDTO) throws PersistenceException;
}