package br.com.centralit.citcorpore.negocio;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import br.com.centralit.citcorpore.bean.AuditoriaItemConfigDTO;
import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.CaracteristicaDTO;
import br.com.centralit.citcorpore.bean.CaracteristicaTipoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.GrupoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.HistoricoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.HistoricoValorDTO;
import br.com.centralit.citcorpore.bean.ItemCfgSolicitacaoServDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.ProblemaDTO;
import br.com.centralit.citcorpore.bean.ProblemaItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.TipoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.bean.ValorDTO;
import br.com.centralit.citcorpore.integracao.AuditoriaItemConfigDao;
import br.com.centralit.citcorpore.integracao.CaracteristicaDao;
import br.com.centralit.citcorpore.integracao.CaracteristicaTipoItemConfiguracaoDAO;
import br.com.centralit.citcorpore.integracao.EmpregadoDao;
import br.com.centralit.citcorpore.integracao.GrupoItemConfiguracaoDAO;
import br.com.centralit.citcorpore.integracao.HistoricoItemConfiguracaoDAO;
import br.com.centralit.citcorpore.integracao.HistoricoValorDAO;
import br.com.centralit.citcorpore.integracao.ItemCfgSolicitacaoServDAO;
import br.com.centralit.citcorpore.integracao.ItemConfiguracaoDao;
import br.com.centralit.citcorpore.integracao.ProblemaDAO;
import br.com.centralit.citcorpore.integracao.ProblemaItemConfiguracaoDAO;
import br.com.centralit.citcorpore.integracao.RequisicaoLiberacaoItemConfiguracaoDao;
import br.com.centralit.citcorpore.integracao.RequisicaoMudancaDao;
import br.com.centralit.citcorpore.integracao.RequisicaoMudancaItemConfiguracaoDao;
import br.com.centralit.citcorpore.integracao.SolicitacaoServicoDao;
import br.com.centralit.citcorpore.integracao.TipoItemConfiguracaoDAO;
import br.com.centralit.citcorpore.integracao.ValorDao;
import br.com.centralit.citcorpore.mail.MensagemEmail;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.CaracteristicaIdentificacao;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.TagTipoItemConfiguracaoDefault;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.Order;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilStrings;

/**
 * @author Maycon.Fernandes
 *
 */
@SuppressWarnings({ "unchecked", "rawtypes" })
public class ItemConfiguracaoServiceEjb extends CrudServiceImpl implements ItemConfiguracaoService {

	private static final Logger LOGGER = Logger.getLogger(ItemConfiguracaoServiceEjb.class);

	// private final Lock lock = new ReentrantLock();

	private boolean situacao = false;

	private TransactionControler transactionControler;

	/** DAOs */
	private ItemConfiguracaoDao itemConfiguracaoDao;
	private ItemConfiguracaoDao itemConfiguracaoDaoReports;
	private TipoItemConfiguracaoDAO tipoItemConfiguracaoDao;
	private CaracteristicaTipoItemConfiguracaoDAO caracteristicaTipoItemConfiguracaoDao;
	private CaracteristicaDao caracteristicaDao;
	private ValorDao valorDao;
	private HistoricoItemConfiguracaoDAO historicoItemConfiguracaoDao;
	private HistoricoValorDAO historicoValorDao;
	private AuditoriaItemConfigDao auditoriaItemConfiguracaoDao;
	private ItemCfgSolicitacaoServDAO itemConfiguracaoSolicitacaoServicoDao;
	private ProblemaItemConfiguracaoDAO problemaItemConfiguracaoDao;
	private RequisicaoMudancaItemConfiguracaoDao requisicaoMudancaItemConfiguracaoDao;
	private RequisicaoLiberacaoItemConfiguracaoDao requisicaoLiberacaoItemConfiguracaoDao;

	private TransactionControler getTransactionControler() throws PersistenceException {
		if (transactionControler == null || !transactionControler.isStarted()) {
			transactionControler = new TransactionControlerImpl(this.getDao().getAliasDB());
			// transactionControler.start();
		}
		return transactionControler;
	}

	@Override
	protected ItemConfiguracaoDao getDao() {
		if (itemConfiguracaoDao == null) {
			itemConfiguracaoDao = new ItemConfiguracaoDao();
		}
		return itemConfiguracaoDao;
	}

	/**
	 * Desenvolvedor: ibimon.morais - Data: 17/08/2015 - Horrio: 08:54 - ID
	 * Citsmart: 176362 - Motivo/Comentrio: Possibilitara gerao dos
	 * relatrios do Citsmart atravs do dataSsource passado por parmetro para
	 * o DAO, citsmart_reports, por exemplo.
	 *
	 * @param databaseAlias
	 * @return dao com o databaseAlias especificado, caso esteja preenchido,
	 *         seno dao com o datasource principal
	 */
	private ItemConfiguracaoDao getDao(String databaseAlias) {
		if (UtilStrings.isNotVazio(databaseAlias)) {
			if (itemConfiguracaoDaoReports == null) {
				itemConfiguracaoDaoReports = new ItemConfiguracaoDao(databaseAlias);
			}
			return itemConfiguracaoDaoReports;
		}
		return this.getDao();
	}

	private CaracteristicaDao getCaracteristicaDao() throws Exception {
		if (caracteristicaDao == null) {
			caracteristicaDao = new CaracteristicaDao();
		}
		return caracteristicaDao;
	}

	private CaracteristicaTipoItemConfiguracaoDAO getCaracteristicaTipoItemConfiguracaoDao() throws Exception {
		if (caracteristicaTipoItemConfiguracaoDao == null) {
			caracteristicaTipoItemConfiguracaoDao = new CaracteristicaTipoItemConfiguracaoDAO();
		}
		return caracteristicaTipoItemConfiguracaoDao;
	}

	private ItemCfgSolicitacaoServDAO getItemConfiguracaoSolicitacaoServicoDao() throws Exception {
		if (itemConfiguracaoSolicitacaoServicoDao == null) {
			itemConfiguracaoSolicitacaoServicoDao = new ItemCfgSolicitacaoServDAO();
		}
		return itemConfiguracaoSolicitacaoServicoDao;
	}

	private HistoricoValorDAO getHistoricoValorDao() throws Exception {
		if (historicoValorDao == null) {
			historicoValorDao = new HistoricoValorDAO();
		}
		return historicoValorDao;
	}

	private ProblemaItemConfiguracaoDAO getProblemaItemConfiguracaoDao() throws Exception {
		if (problemaItemConfiguracaoDao == null) {
			problemaItemConfiguracaoDao = new ProblemaItemConfiguracaoDAO();
		}
		return problemaItemConfiguracaoDao;
	}

	private RequisicaoMudancaItemConfiguracaoDao getRequisicaoMudancaItemConfiguracaoDao() throws Exception {
		if (requisicaoMudancaItemConfiguracaoDao == null) {
			requisicaoMudancaItemConfiguracaoDao = new RequisicaoMudancaItemConfiguracaoDao();
		}
		return requisicaoMudancaItemConfiguracaoDao;
	}

	private RequisicaoLiberacaoItemConfiguracaoDao getRequisicaoLiberacaoItemConfiguracaoDao() throws Exception {
		if (requisicaoLiberacaoItemConfiguracaoDao == null) {
			requisicaoLiberacaoItemConfiguracaoDao = new RequisicaoLiberacaoItemConfiguracaoDao();
		}
		return requisicaoLiberacaoItemConfiguracaoDao;
	}

	private HistoricoItemConfiguracaoDAO getHistoricoItemConfiguracaoDao() throws Exception {
		if (historicoItemConfiguracaoDao == null) {
			historicoItemConfiguracaoDao = new HistoricoItemConfiguracaoDAO();
		}
		return historicoItemConfiguracaoDao;
	}

	private AuditoriaItemConfigDao getAuditoriaItemConfiguracaoDao() throws Exception {
		if (auditoriaItemConfiguracaoDao == null) {
			auditoriaItemConfiguracaoDao = new AuditoriaItemConfigDao();
		}
		return auditoriaItemConfiguracaoDao;
	}

	private TipoItemConfiguracaoDAO getTipoItemConfiguracaoDAO() throws Exception {
		if (tipoItemConfiguracaoDao == null) {
			tipoItemConfiguracaoDao = new TipoItemConfiguracaoDAO();
		}
		return tipoItemConfiguracaoDao;
	}

	/**
	 * Retorna DAO de Valor.
	 *
	 * @return valor do atributo valorDao.
	 * @author valdoilo.damasceno
	 */
	private ValorDao getValorDao() {
		if (valorDao == null) {
			valorDao = new ValorDao();
		}
		return valorDao;
	}

	@Override
	public ItemConfiguracaoDTO createItemConfiguracao(ItemConfiguracaoDTO itemConfiguracao, UsuarioDTO user) throws Exception {
		situacao = false;

		/*
		 * Inserido por Emauri - 23/11/2013
		 */
		TransactionControler transactionControler = this.getTransactionControler();
		/*
		 * Fim - Inserido por Emauri - 23/11/2013
		 */

		try {
			this.getCaracteristicaTipoItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getCaracteristicaDao().setTransactionControler(transactionControler);
			this.getValorDao().setTransactionControler(transactionControler);
			this.getTipoItemConfiguracaoDAO().setTransactionControler(transactionControler);
			this.getHistoricoItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getHistoricoValorDao().setTransactionControler(transactionControler);
			this.getAuditoriaItemConfiguracaoDao().setTransactionControler(transactionControler);

			if (transactionControler.isStarted() == false) {
				transactionControler.start();
			}

			List<TipoItemConfiguracaoDTO> listaTipo = itemConfiguracao.getTipoItemConfiguracao();

			List<ItemConfiguracaoDTO> lstItemConfiguracaoFilhos = null;
			boolean verificaGravacaoIc = false;

			/**
			 * Se existe item de configurao com a mesma identificao
			 */
			ItemConfiguracaoDTO itemConfiguracaoExistente;

			if ((itemConfiguracaoExistente = this.getDao().findByIdentificacaoItemConfiguracao(itemConfiguracao)) != null) {
				ItemConfiguracaoDTO itemConfiguracaoOld = itemConfiguracaoExistente;

				itemConfiguracaoExistente.setDataInicio(UtilDatas.getDataAtual());
				itemConfiguracaoExistente.setDtUltimaCaptura(UtilDatas.getDataHoraAtual());

				if (itemConfiguracaoExistente.getNome() == null) {
					itemConfiguracaoExistente.setNome(itemConfiguracaoExistente.getIdentificacao());
				}

				this.getDao().updateNotNull(itemConfiguracaoExistente);

				itemConfiguracao = itemConfiguracaoExistente;

				/**
				 * SETA DATAFIM Atualizando o itens filhos relacionados. Atribui
				 * DataFim para todos os Itens de Configurao Filhos. Em
				 * gravarItemConfiguracaoFilho esses Itens Filhos sero
				 * atualizados, conforme as informaes do novo inventrio,
				 * removendo a DataFim caso ainda exista no novo inventrio.
				 * Essa verificao  feira atravs de sua identificao.
				 */
				this.getDao().updateItemConfiguracaoFilho(itemConfiguracao.getIdItemConfiguracao(), UtilDatas.getDataAtual(), UtilDatas.getDataHoraAtual());

				lstItemConfiguracaoFilhos = (List<ItemConfiguracaoDTO>) this.getDao().listItemConfiguracaoFilho(itemConfiguracao);

				if (lstItemConfiguracaoFilhos != null && !lstItemConfiguracaoFilhos.isEmpty()) {
					verificaGravacaoIc = true;
				}

			} else {
				/**
				 * Cria o item de configurao
				 */
				itemConfiguracao.setDataInicio(UtilDatas.getDataAtual());
				itemConfiguracao.setDtUltimaCaptura(UtilDatas.getDataHoraAtual());
				itemConfiguracao.setNome(itemConfiguracao.getIdentificacao());

				itemConfiguracao = (ItemConfiguracaoDTO) getDao().create(itemConfiguracao);

				if (itemConfiguracao.getIdItemConfiguracao() != null) {
					this.getHistoricoItemConfiguracaoDao().create(this.createHistoricoItem(itemConfiguracao, null));
				}
			}

			if (listaTipo != null && !listaTipo.isEmpty()) {
			/** Itera os tipos de item. **/
			for (TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO : listaTipo) {

				List<CaracteristicaDTO> lstCaracteristica = tipoItemConfiguracaoDTO.getCaracteristicas();

				/** Grava TipoItemConfiguracao. **/
				tipoItemConfiguracaoDTO = this.gravarTipoItemConfiguracao(tipoItemConfiguracaoDTO);

				tipoItemConfiguracaoDTO.setCaracteristicas(lstCaracteristica);

				/** Cria ou Atualiza o ItemConfiguracaoFilho. **/
				ItemConfiguracaoDTO itemConfiguracaoFilhoGravado = this.gravarItemConfiguracaoFilho(itemConfiguracao, tipoItemConfiguracaoDTO);

				if (lstCaracteristica != null && !lstCaracteristica.isEmpty()) {

					for (CaracteristicaDTO caracteristicaBean : lstCaracteristica) {

						ValorDTO valorDTO = caracteristicaBean.getValor();

						caracteristicaBean = this.gravarCaracteristica(caracteristicaBean, tipoItemConfiguracaoDTO);

						valorDTO.setValorStr(StringEscapeUtils.escapeJava(valorDTO.getValorStr()));

						this.gravarValor(valorDTO, caracteristicaBean, itemConfiguracaoFilhoGravado, itemConfiguracaoFilhoGravado.getHistoricoItemConfiguracaoDTO(), verificaGravacaoIc);

					}
				}
			}
			}

			itemConfiguracao.setDataFim(UtilDatas.getDataAtual());

			List<ItemConfiguracaoDTO> listItemConfiguracaoDto = this.retornaItemConfiguracaoFinalizadoByIdItemConfiguracao(itemConfiguracao);

			if (listItemConfiguracaoDto != null && !listItemConfiguracaoDto.isEmpty()) {
				for (ItemConfiguracaoDTO itemConfiguracaoDTO : listItemConfiguracaoDto) {
					this.getAuditoriaItemConfiguracaoDao().create(this.gravarAuditoriaItemConfig(itemConfiguracaoDTO, null, null, null, Enumerados.TipoAlteracao.Desativado.getIdentificador()));
				}
			}

			transactionControler.commit();

		} catch (Exception e) {

			e.printStackTrace();

			this.rollbackTransaction(transactionControler, e);

		} finally {
			try {
				transactionControler.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
			}

		}

		return itemConfiguracao;

	}

	/**
	 * Grava Tipo Item configuracao.
	 */
	public synchronized TipoItemConfiguracaoDTO gravarTipoItemConfiguracao(TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO) throws Exception {

		try {
			List listTipoItemConf = getTipoItemConfiguracaoDAO().findByNomeTipoItemConfiguracao(tipoItemConfiguracaoDTO.getNome());

			if (listTipoItemConf != null && !listTipoItemConf.isEmpty()) {
				tipoItemConfiguracaoDTO = (TipoItemConfiguracaoDTO) listTipoItemConf.get(0);
			} else {
				tipoItemConfiguracaoDTO.setDataInicio(UtilDatas.getDataAtual());
				tipoItemConfiguracaoDTO.setIdEmpresa(1);
				tipoItemConfiguracaoDTO.setSistema("S");

				tipoItemConfiguracaoDTO = (TipoItemConfiguracaoDTO) getTipoItemConfiguracaoDAO().create(tipoItemConfiguracaoDTO);
			}

		} catch (Exception e) {
			System.out.println("Problema ao gravar tipoItemConfiguracao: " + e);
			e.printStackTrace();
		}

		return tipoItemConfiguracaoDTO;
	}

	/**
	 * Gravar Caracteristica do Tipo Item Configuracao.
	 */
	private synchronized CaracteristicaDTO gravarCaracteristica(CaracteristicaDTO caracteristicaBean, TipoItemConfiguracaoDTO tipoitemconfiguracao) throws Exception {

		try {

			List lstExisteCaract = this.getCaracteristicaDao().consultarCaracteristicas("", caracteristicaBean.getTag(), false);

			if (lstExisteCaract != null && !lstExisteCaract.isEmpty()) {
				caracteristicaBean = (CaracteristicaDTO) lstExisteCaract.get(0);
			} else {
				caracteristicaBean.setIdEmpresa(1);
				caracteristicaBean.setTipo("A");
				caracteristicaBean.setDataInicio(UtilDatas.getDataAtual());
				caracteristicaBean.setSistema("S");

				caracteristicaBean = (CaracteristicaDTO) this.getCaracteristicaDao().create(caracteristicaBean);
			}

			List lstExisteCaractTipoItem = this.getCaracteristicaDao().consultarCaracteristicas(tipoitemconfiguracao.getTag(), caracteristicaBean.getTag(), false);

			if (lstExisteCaractTipoItem == null || lstExisteCaractTipoItem.size() == 0) {
				this.gravarCaracteristicaTipoItemConfiguracaoDTO(tipoitemconfiguracao, caracteristicaBean);
			}

		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("PROBLEMA AO GRAVAR CARACTERISTICA!");
		}

		return caracteristicaBean;
	}

	/**
	 * Grava Valor Relacionado a caracteristica de Item configuracao do tipo item Configuracao.
	 */
	private ValorDTO gravarValor(ValorDTO valorDTO, CaracteristicaDTO caracteristicaBean, ItemConfiguracaoDTO itemConfiguracaoFilhoGravado, HistoricoItemConfiguracaoDTO historicoIc, boolean verificaGravacaoIc) throws Exception {

		try {

			ValorDTO valorBean = this.getValorDao().restoreItemConfiguracao(itemConfiguracaoFilhoGravado.getIdItemConfiguracao(), caracteristicaBean.getIdCaracteristica());

			if (valorBean == null) {
				valorDTO.setIdItemConfiguracao(itemConfiguracaoFilhoGravado.getIdItemConfiguracao());
				valorDTO.setIdCaracteristica(caracteristicaBean.getIdCaracteristica());

				valorDTO = (ValorDTO) getValorDao().create(valorDTO);

				if (verificaGravacaoIc) {
					// Verifica situacao para gravar log somente uma vez, como pode ser alterado somente a uma valor de uma caracteristica
					if (!this.situacao) {
						getAuditoriaItemConfiguracaoDao().create(this.gravarAuditoriaItemConfig(itemConfiguracaoFilhoGravado, null, null, null, Enumerados.TipoAlteracao.Criacao.getIdentificador()));
						this.situacao = true;
					}
				}
			} else {

				TipoItemConfiguracaoDTO tipoItemConfiguracaoDto = new TipoItemConfiguracaoDTO();

				tipoItemConfiguracaoDto.setId(itemConfiguracaoFilhoGravado.getIdTipoItemConfiguracao());

				ValorDTO valorByIdIC = this.getValorDao().restoreValorByIdItemConfiguracao(itemConfiguracaoFilhoGravado.getIdItemConfiguracao(), caracteristicaBean.getIdCaracteristica(), valorDTO.getValorStr());

				valorBean.setValorStr(valorDTO.getValorStr());

				if (historicoIc != null && historicoIc.getIdHistoricoIC() != null) {
					// Grava Historico valor item configuracao e grava auditoria
					this.getHistoricoValorDao().create(this.createHistoricoValor(valorBean, null, historicoIc.getIdHistoricoIC().intValue()));
				}

				if (valorByIdIC == null) {
					if (verificaGravacaoIc) {
						if (!this.situacao) {
							this.getAuditoriaItemConfiguracaoDao().create(this.gravarAuditoriaItemConfig(itemConfiguracaoFilhoGravado, null, null, null, Enumerados.TipoAlteracao.Alteracao.getIdentificador()));
							this.situacao = true;
						}
					}
				}

				this.getValorDao().update(valorBean);
			}

		} catch (Exception e) {
			System.out.println("Problema ao gravar valor: " + e.getMessage());
		}
		return valorDTO;
	}

	/**
	 * Grava Item Configuracao Filho.
	 */
	private synchronized ItemConfiguracaoDTO gravarItemConfiguracaoFilho(ItemConfiguracaoDTO itemConfiguracaoPai, TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO) throws Exception {

		ItemConfiguracaoDTO itemConfiguracaoFilho = new ItemConfiguracaoDTO();

		try {

			itemConfiguracaoFilho.setIdItemConfiguracaoPai(itemConfiguracaoPai.getIdItemConfiguracao());
			itemConfiguracaoFilho.setIdTipoItemConfiguracao(tipoItemConfiguracaoDTO.getId());
			itemConfiguracaoFilho.setDataInicio(UtilDatas.getDataAtual());

			String identificacao = this.obterIdentificacaoItemConfiguracaoFilho(tipoItemConfiguracaoDTO);

			if (identificacao.length() > 400) {
				identificacao = identificacao.substring(0, 399);
			}

			itemConfiguracaoFilho.setIdentificacao(StringUtils.replace(identificacao, "\0 ", ""));

			itemConfiguracaoFilho = this.getDao().obterICFilhoPorIdentificacaoIdPaiEIdTipo(itemConfiguracaoFilho);

			if (itemConfiguracaoFilho.getIdItemConfiguracao() != null) {
				itemConfiguracaoFilho.setDataFim(null);

				this.getDao().updateItemConfiguracaoFilho(itemConfiguracaoFilho.getIdItemConfiguracao(), null, null);

				this.getDao().update(itemConfiguracaoFilho);
			} else {
				itemConfiguracaoFilho = (ItemConfiguracaoDTO) this.getDao().create(itemConfiguracaoFilho);
			}

		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("PROBLEMA AO GRAVAR ITEM CONFIGURACAO FILHO! ");
		}

		return itemConfiguracaoFilho;
	}

	/**
	 * Grava Vinculo Caracteristica e Tipo Item Configurao.
	 */
	private synchronized CaracteristicaTipoItemConfiguracaoDTO gravarCaracteristicaTipoItemConfiguracaoDTO(TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO, CaracteristicaDTO caracteristicaBean) {

		CaracteristicaTipoItemConfiguracaoDTO caracteristicaTipoItemConfiguracaoBean = new CaracteristicaTipoItemConfiguracaoDTO();

		try {

			caracteristicaTipoItemConfiguracaoBean.setIdTipoItemConfiguracao(tipoItemConfiguracaoDTO.getId());
			caracteristicaTipoItemConfiguracaoBean.setIdCaracteristica(caracteristicaBean.getIdCaracteristica());
			caracteristicaTipoItemConfiguracaoBean.setDataInicio(UtilDatas.getDataAtual());
			caracteristicaTipoItemConfiguracaoBean.setNameInfoAgente(caracteristicaBean.getNome());

			this.getCaracteristicaTipoItemConfiguracaoDao().create(caracteristicaTipoItemConfiguracaoBean);

		} catch (Exception e) {
			System.out.println("PROBLEMA AO GRAVAR CARACTERISTICA TIPO ITEM CONFIGURACAO!");
		}

		return caracteristicaTipoItemConfiguracaoBean;
	}

	@Override
	public ItemConfiguracaoDTO restoreByIdItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		ArrayList<Condition> condicoes = new ArrayList<Condition>();

		condicoes.add(new Condition("idItemConfiguracao", "=", idItemConfiguracao));

		try {

			ArrayList<ItemConfiguracaoDTO> retorno = (ArrayList<ItemConfiguracaoDTO>) getDao().findByCondition(condicoes, null);

			if (retorno != null) {

				return retorno.get(0);

			}

		} catch (Exception e) {

			e.printStackTrace();

		}

		return null;
	}

	/**
	 * Realiza a criao do item de configurao.
	 *
	 * @param itemConfiguracao
	 * @param user
	 * @return
	 * @throws ServiceException
	 * @throws LogicException
	 * @author rodrigo.acorse
	 */
	//TODO
	@Override
	public ItemConfiguracaoDTO create(HttpServletRequest request, ItemConfiguracaoDTO itemConfiguracaoDTO) throws ServiceException, LogicException {
		TransactionControler transactionControler = new TransactionControlerImpl(getDao().getAliasDB());

		try {
			UsuarioDTO usuarioDTO = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);

			this.validaCreate(itemConfiguracaoDTO);

			this.getDao().setTransactionControler(transactionControler);
			this.getRequisicaoMudancaItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getProblemaItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getItemConfiguracaoSolicitacaoServicoDao().setTransactionControler(transactionControler);
			this.getRequisicaoLiberacaoItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getHistoricoItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getHistoricoValorDao().setTransactionControler(transactionControler);
			this.getValorDao().setTransactionControler(transactionControler);
			this.getAuditoriaItemConfiguracaoDao().setTransactionControler(transactionControler);

			transactionControler.start();

			if (itemConfiguracaoDTO != null) {
				itemConfiguracaoDTO.setDataInicio(UtilDatas.getDataAtual());
			}

			if (itemConfiguracaoDTO != null && itemConfiguracaoDTO.getIdGrupoItemConfiguracao() != null) {
				if (itemConfiguracaoDTO.getIdGrupoItemConfiguracao() == 1000) {
					throw new LogicException("Voc deve criar um novo Grupo e fazer a vinculao com ele.");
				}
			}

			//Realiza o create.
			itemConfiguracaoDTO = (ItemConfiguracaoDTO) getDao().create(itemConfiguracaoDTO);

			HistoricoItemConfiguracaoDTO historicoItemConfiguracaoDTO = new HistoricoItemConfiguracaoDTO();
			if (itemConfiguracaoDTO.getIdItemConfiguracao() != null) {
				historicoItemConfiguracaoDTO = (HistoricoItemConfiguracaoDTO) this.getHistoricoItemConfiguracaoDao().create(this.createHistoricoItem(itemConfiguracaoDTO, usuarioDTO));
			}

			relacaoMudanca(itemConfiguracaoDTO);
			relacaoProblema(itemConfiguracaoDTO);
			relacaoIncidente(itemConfiguracaoDTO);
			relacaoLiberacao(itemConfiguracaoDTO);

			enviarEmailNotificacao(itemConfiguracaoDTO, transactionControler, "CRIA_IC");

			if (itemConfiguracaoDTO.getListCaracteristicas() != null && !itemConfiguracaoDTO.getListCaracteristicas().isEmpty() && historicoItemConfiguracaoDTO != null && historicoItemConfiguracaoDTO.getIdHistoricoIC() != null) {
				boolean situacao = false;

				for (CaracteristicaDTO caracteristicaDTO : itemConfiguracaoDTO.getListCaracteristicas()) {
					ValorDTO valorDTO = this.getValorDao().restoreItemConfiguracao(itemConfiguracaoDTO.getIdItemConfiguracao(), caracteristicaDTO.getIdCaracteristica());

					if (valorDTO != null) {
						valorDTO.setValorStr(caracteristicaDTO.getValorString());
						valorDTO.setValorLongo(caracteristicaDTO.getValorString());

						this.getValorDao().update(valorDTO);

						this.getHistoricoValorDao().create(this.createHistoricoValor(valorDTO, usuarioDTO, historicoItemConfiguracaoDTO.getIdHistoricoIC()));

						if (this.getValorDao().restoreValorByIdItemConfiguracao(itemConfiguracaoDTO.getIdItemConfiguracao(), caracteristicaDTO.getIdCaracteristica(), valorDTO.getValorStr()) == null) {
							if (!situacao) {
								this.getAuditoriaItemConfiguracaoDao().create(this.gravarAuditoriaItemConfig(itemConfiguracaoDTO, null, null, usuarioDTO, Enumerados.TipoAlteracao.Alteracao.getIdentificador()));
								situacao = true;
							}

						} else if (this.getHistoricoValorDao().restoreValorByIdValor(valorDTO.getIdValor()) == null) {
							if (!situacao) {
								this.getAuditoriaItemConfiguracaoDao().create(this.gravarAuditoriaItemConfig(itemConfiguracaoDTO, null, null, usuarioDTO, Enumerados.TipoAlteracao.Alteracao.getIdentificador()));
								situacao = true;
							}
						}
					} else {
						valorDTO = new ValorDTO();

						valorDTO.setIdItemConfiguracao(itemConfiguracaoDTO.getIdItemConfiguracao());
						valorDTO.setIdCaracteristica(caracteristicaDTO.getIdCaracteristica());
						valorDTO.setValorStr(caracteristicaDTO.getValorString());
						valorDTO.setValorLongo(caracteristicaDTO.getValorString());

						this.getValorDao().create(valorDTO);

						this.getHistoricoValorDao().create(this.createHistoricoValor(valorDTO, usuarioDTO, historicoItemConfiguracaoDTO.getIdHistoricoIC()));

						HistoricoItemConfiguracaoDTO historioConfiguracaoDTO = new HistoricoItemConfiguracaoDTO();
						historioConfiguracaoDTO.setIdHistoricoIC(historicoItemConfiguracaoDTO.getIdHistoricoIC());
						itemConfiguracaoDTO.setHistoricoItemConfiguracaoDTO(historioConfiguracaoDTO);

						if (!situacao) {
							this.getAuditoriaItemConfiguracaoDao().create(this.gravarAuditoriaItemConfig(itemConfiguracaoDTO, null, null, usuarioDTO, Enumerados.TipoAlteracao.Criacao.getIdentificador()));
							situacao = true;
						}
					}
				}
			}

			transactionControler.commit();
		} catch (Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(transactionControler, e);
		} finally {
			try {
				transactionControler.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
			}
		}

		return itemConfiguracaoDTO;
	}

	/**
	 * Realiza a atualizao do item de configurao.
	 *
	 * Salva tambem as entidades HistoricoItemConfiguracaoDTO,
	 * AuditoriaItemConfigDTO, ValorDTO, HistoricoValorDTO
	 *
	 * @param itemConfiguracao
	 * @param user
	 * @return
	 * @throws ServiceException
	 * @throws LogicException
	 * @author rodrigo.acorse
	 */
	@Override
	public ItemConfiguracaoDTO update(HttpServletRequest request, ItemConfiguracaoDTO itemConfiguracaoDTO) throws ServiceException, LogicException {
		TransactionControler transactionControler = new TransactionControlerImpl(getDao().getAliasDB());

		try {
			UsuarioDTO usuarioDTO = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);

			validaUpdate(itemConfiguracaoDTO);

			this.getDao().setTransactionControler(transactionControler);
			this.getRequisicaoMudancaItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getProblemaItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getItemConfiguracaoSolicitacaoServicoDao().setTransactionControler(transactionControler);
			this.getRequisicaoLiberacaoItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getHistoricoItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getHistoricoValorDao().setTransactionControler(transactionControler);
			this.getValorDao().setTransactionControler(transactionControler);
			this.getAuditoriaItemConfiguracaoDao().setTransactionControler(transactionControler);

			transactionControler.start();

			ItemConfiguracaoDTO itemConfiguracaoOld = (ItemConfiguracaoDTO) this.restore(itemConfiguracaoDTO);

			//Realiza o update.
			getDao().update(itemConfiguracaoDTO);

			HistoricoItemConfiguracaoDTO historicoItemConfiguracaoDTO = new HistoricoItemConfiguracaoDTO();
			if (itemConfiguracaoDTO.getIdItemConfiguracao() != null) {
				historicoItemConfiguracaoDTO = (HistoricoItemConfiguracaoDTO) this.getHistoricoItemConfiguracaoDao().create(this.createHistoricoItem(itemConfiguracaoDTO, usuarioDTO));
			}

			relacaoMudanca(itemConfiguracaoDTO);
			relacaoProblema(itemConfiguracaoDTO);
			relacaoIncidente(itemConfiguracaoDTO);
			relacaoLiberacao(itemConfiguracaoDTO);

			enviarEmailNotificacao(itemConfiguracaoDTO, transactionControler, "ALT_IC");

			if (itemConfiguracaoDTO.getListCaracteristicas() != null && !itemConfiguracaoDTO.getListCaracteristicas().isEmpty() && historicoItemConfiguracaoDTO != null && historicoItemConfiguracaoDTO.getIdHistoricoIC() != null) {

				for (CaracteristicaDTO caracteristicaDTO : itemConfiguracaoDTO.getListCaracteristicas()) {
					ValorDTO valorDTO = this.getValorDao().restoreItemConfiguracao(itemConfiguracaoDTO.getIdItemConfiguracao(), caracteristicaDTO.getIdCaracteristica());
					HistoricoValorDTO historicoValor;
					if (valorDTO != null) {

						String valorAux = caracteristicaDTO.getValorString();

						if (valorAux != null && !valorAux.equalsIgnoreCase(valorDTO.getValorStr())) {

							valorDTO.setValorStr(caracteristicaDTO.getValorString());
							valorDTO.setValorLongo(caracteristicaDTO.getValorString());
							this.getValorDao().update(valorDTO);

							historicoValor = new HistoricoValorDTO();
							historicoValor = (HistoricoValorDTO) this.getHistoricoValorDao().create(this.createHistoricoValor(valorDTO, usuarioDTO, historicoItemConfiguracaoDTO.getIdHistoricoIC()));

							this.getAuditoriaItemConfiguracaoDao().create(this.gravarAuditoriaItemConfig(itemConfiguracaoDTO, historicoValor, valorDTO, usuarioDTO, Enumerados.TipoAlteracao.Alteracao.getIdentificador()));

						}

					} else {
						valorDTO = new ValorDTO();

						valorDTO.setIdItemConfiguracao(itemConfiguracaoDTO.getIdItemConfiguracao());
						valorDTO.setIdCaracteristica(caracteristicaDTO.getIdCaracteristica());
						valorDTO.setValorStr(caracteristicaDTO.getValorString());
						valorDTO.setValorLongo(caracteristicaDTO.getValorString());

						valorDTO = (ValorDTO) this.getValorDao().create(valorDTO);

						historicoValor = new HistoricoValorDTO();
						historicoValor = (HistoricoValorDTO) this.getHistoricoValorDao().create(this.createHistoricoValor(valorDTO, usuarioDTO, historicoItemConfiguracaoDTO.getIdHistoricoIC()));

						HistoricoItemConfiguracaoDTO historioConfiguracaoDTO = new HistoricoItemConfiguracaoDTO();
						historioConfiguracaoDTO.setIdHistoricoIC(historicoItemConfiguracaoDTO.getIdHistoricoIC());
						itemConfiguracaoDTO.setHistoricoItemConfiguracaoDTO(historioConfiguracaoDTO);

						this.getAuditoriaItemConfiguracaoDao().create(this.gravarAuditoriaItemConfig(itemConfiguracaoDTO, historicoValor, valorDTO, usuarioDTO, Enumerados.TipoAlteracao.Criacao.getIdentificador()));
					}
				}
			}

			transactionControler.commit();
		} catch (Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(transactionControler, e);
		} finally {
			try {
				transactionControler.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
			}
		}

		return itemConfiguracaoDTO;
	}

	@Override
	public ItemConfiguracaoDTO createItemConfiguracaoAplicacao(ItemConfiguracaoDTO itemConfiguracao, UsuarioDTO user) throws ServiceException, LogicException {

		TransactionControler transactionControler = new TransactionControlerImpl(this.getDao().getAliasDB());

		try {
			HistoricoItemConfiguracaoDTO ic = new HistoricoItemConfiguracaoDTO();

			this.validaCreate(itemConfiguracao);
			this.getDao().setTransactionControler(transactionControler);
			this.getHistoricoItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getValorDao().setTransactionControler(transactionControler);
			this.getAuditoriaItemConfiguracaoDao().setTransactionControler(transactionControler);

			transactionControler.start();

			if (itemConfiguracao != null && itemConfiguracao.getIdItemConfiguracaoPai() != null) {
				ItemConfiguracaoDTO itemConfiguracaoPai = new ItemConfiguracaoDTO();
				itemConfiguracaoPai.setIdItemConfiguracao(itemConfiguracao.getIdItemConfiguracaoPai());
				itemConfiguracaoPai = (ItemConfiguracaoDTO) this.restore(itemConfiguracaoPai);
			}

			if (itemConfiguracao != null) {
				itemConfiguracao.setDataInicio(UtilDatas.getDataAtual());
			}

			if (itemConfiguracao != null && itemConfiguracao.getIdGrupoItemConfiguracao() != null) {
				if (itemConfiguracao.getIdGrupoItemConfiguracao() == 1000) {
					throw new LogicException("Voc deve criar um novo Grupo e fazer a vinculao com ele.");
				}
			}
			itemConfiguracao = (ItemConfiguracaoDTO) getDao().create(itemConfiguracao);
			if (itemConfiguracao.getIdItemConfiguracao() != null) {
				ic = (HistoricoItemConfiguracaoDTO) this.getHistoricoItemConfiguracaoDao().create(this.createHistoricoItem(itemConfiguracao, user));
			}
			relacaoMudanca(itemConfiguracao);
			relacaoProblema(itemConfiguracao);
			relacaoIncidente(itemConfiguracao);
			relacaoLiberacao(itemConfiguracao);

			enviarEmailNotificacao(itemConfiguracao, transactionControler, "CRIA_IC");

			this.criarEAssociarValorDaCaracteristicaAoItemConfiguracao(itemConfiguracao, user, ic.getIdHistoricoIC());

			transactionControler.commit();

		} catch (Exception e) {

			e.printStackTrace();
			this.rollbackTransaction(transactionControler, e);

		} finally {
			try {
				transactionControler.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
			}

		}

		return itemConfiguracao;
	}

	/**
	 * Retorna Service de Valor.
	 *
	 * @return ValorService
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	public ValorService getValorService() throws ServiceException, Exception {
		return (ValorService) ServiceLocator.getInstance().getService(ValorService.class, null);
	}

	/**
	 * Retorna Service de Valor.
	 *
	 * @return ValorService
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	public UsuarioService getUsuarioService() throws ServiceException, Exception {
		return (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
	}

	/**
	 * Cria ou Atualiza associao do Valor da Caracterstica ao tem de
	 * Configurao.
	 *
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	@Override
	public void criarEAssociarValorDaCaracteristicaAoItemConfiguracao(ItemConfiguracaoDTO itemConfiguracaoDto, UsuarioDTO user, Integer idHistoricoIC) throws Exception {

		if (itemConfiguracaoDto.getTipoItemConfiguracaoSerializadas() != null && itemConfiguracaoDto.getTipoItemConfiguracaoSerializadas().getCaracteristicas() != null && !itemConfiguracaoDto.getTipoItemConfiguracaoSerializadas().getCaracteristicas().isEmpty() && idHistoricoIC != null) {
			boolean situacao = false;

			for (int i = 0; i < itemConfiguracaoDto.getTipoItemConfiguracaoSerializadas().getCaracteristicas().size(); i++) {

				ValorDTO valor = this.getValorDao().restoreItemConfiguracao(itemConfiguracaoDto.getIdItemConfiguracao(), ((CaracteristicaDTO) itemConfiguracaoDto.getTipoItemConfiguracaoSerializadas().getCaracteristicas().get(i)).getIdCaracteristica());

				if (valor != null) {

					valor.setValorStr(((CaracteristicaDTO) itemConfiguracaoDto.getTipoItemConfiguracaoSerializadas().getCaracteristicas().get(i)).getValorString());
					valor.setValorLongo(((CaracteristicaDTO) itemConfiguracaoDto.getTipoItemConfiguracaoSerializadas().getCaracteristicas().get(i)).getValorString());

					ValorDTO valorDto = this.getValorDao().restoreValorByIdItemConfiguracao(itemConfiguracaoDto.getIdItemConfiguracao(), ((CaracteristicaDTO) itemConfiguracaoDto.getTipoItemConfiguracaoSerializadas().getCaracteristicas().get(i)).getIdCaracteristica(), valor.getValorStr());
					HistoricoValorDTO historicoValorbean = this.getHistoricoValorDao().restoreValorByIdValor(valor.getIdValor());
					this.getValorDao().update(valor);
					this.getHistoricoValorDao().create(this.createHistoricoValor(valor, user, idHistoricoIC));

					if (valorDto == null) {
						if (!situacao) {
							this.getAuditoriaItemConfiguracaoDao().create(this.gravarAuditoriaItemConfig(itemConfiguracaoDto, null, null, user, Enumerados.TipoAlteracao.Alteracao.getIdentificador()));
							situacao = true;
						}

					} else if (historicoValorbean == null) {
						if (!situacao) {
							this.getAuditoriaItemConfiguracaoDao().create(this.gravarAuditoriaItemConfig(itemConfiguracaoDto, null, null, user, Enumerados.TipoAlteracao.Alteracao.getIdentificador()));
							situacao = true;
						}
					}

				} else {
					HistoricoItemConfiguracaoDTO historioConfiguracaoDTO = new HistoricoItemConfiguracaoDTO();
					valor = new ValorDTO();
					valor.setIdItemConfiguracao(itemConfiguracaoDto.getIdItemConfiguracao());
					valor.setIdCaracteristica(((CaracteristicaDTO) itemConfiguracaoDto.getTipoItemConfiguracaoSerializadas().getCaracteristicas().get(i)).getIdCaracteristica());
					valor.setValorStr(((CaracteristicaDTO) itemConfiguracaoDto.getTipoItemConfiguracaoSerializadas().getCaracteristicas().get(i)).getValorString());
					valor.setValorLongo(((CaracteristicaDTO) itemConfiguracaoDto.getTipoItemConfiguracaoSerializadas().getCaracteristicas().get(i)).getValorString());
					this.getValorDao().create(valor);

					this.getHistoricoValorDao().create(this.createHistoricoValor(valor, user, idHistoricoIC));
					historioConfiguracaoDTO.setIdHistoricoIC(idHistoricoIC);
					itemConfiguracaoDto.setHistoricoItemConfiguracaoDTO(historioConfiguracaoDTO);
					if (!situacao) {
						this.getAuditoriaItemConfiguracaoDao().create(this.gravarAuditoriaItemConfig(itemConfiguracaoDto, null, null, user, Enumerados.TipoAlteracao.Criacao.getIdentificador()));
						situacao = true;
					}

				}
			}
		}
	}

	@Override
	public ItemConfiguracaoDTO listIdUsuario(String obj) throws Exception {

		try {
			return getDao().listIdUsuario(obj);
		} catch (Exception e) {
			throw new ServiceException(e);

		}
	}

	/**
	 * Alterado para no criar mltiplas transaes 02/01/2015 - 14:09
	 *
	 * @author rafael.soyer
	 * @author thyen.chan
	 */
	@Override
	public void updateItemConfiguracao(IDto ItemConfiguracao, UsuarioDTO user) throws ServiceException, LogicException {

		ItemConfiguracaoDTO itemConfiguracaoDto = new ItemConfiguracaoDTO();
		TransactionControler transactionControler = new TransactionControlerImpl(getDao().getAliasDB());

		HistoricoItemConfiguracaoDTO ic = new HistoricoItemConfiguracaoDTO();
		itemConfiguracaoDto = (ItemConfiguracaoDTO) ItemConfiguracao;
		try {

			this.getHistoricoItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getRequisicaoMudancaItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getProblemaItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getItemConfiguracaoSolicitacaoServicoDao().setTransactionControler(transactionControler);
			this.getRequisicaoLiberacaoItemConfiguracaoDao().setTransactionControler(transactionControler);
			this.getValorDao().setTransactionControler(transactionControler);
			this.getHistoricoValorDao().setTransactionControler(transactionControler);
			transactionControler.start();
			/* Gravando o historico */
			if (itemConfiguracaoDto.getIdItemConfiguracao() != null) {
				ic = (HistoricoItemConfiguracaoDTO) this.getHistoricoItemConfiguracaoDao().create(this.createHistoricoItem(itemConfiguracaoDto, user));
			}

			relacaoMudanca(itemConfiguracaoDto);
			relacaoProblema(itemConfiguracaoDto);
			relacaoIncidente(itemConfiguracaoDto);
			relacaoLiberacao(itemConfiguracaoDto);

			enviarEmailNotificacao(itemConfiguracaoDto, transactionControler, "ALT_IC");

			transactionControler.commit();
			transactionControler.closeQuietly();

			this.criarEAssociarValorDaCaracteristicaAoItemConfiguracao(itemConfiguracaoDto, user, ic.getIdHistoricoIC());

			getDao().update(itemConfiguracaoDto);
		} catch (Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(transactionControler, e);
		}

	}

	public void relacaoMudanca(ItemConfiguracaoDTO item) throws ServiceException, Exception {
		/* Gravando o relacionamento com mudanca */
		if (item.getIdMudanca() != null) {
			RequisicaoMudancaItemConfiguracaoDTO m = new RequisicaoMudancaItemConfiguracaoDTO();
			m.setIdItemConfiguracao(item.getIdItemConfiguracao());
			m.setIdRequisicaoMudanca(item.getIdMudanca());
			if (!this.getRequisicaoMudancaItemConfiguracaoDao().verificaSeCadastrado(m)) {
				this.getRequisicaoMudancaItemConfiguracaoDao().create(m);
			}
		}
	}

	public void relacaoProblema(ItemConfiguracaoDTO item) throws ServiceException, Exception {
		/* Gravando o relacionamento com problema */
		if (item.getIdProblema() != null) {
			ProblemaItemConfiguracaoDTO m = new ProblemaItemConfiguracaoDTO();
			m.setIdItemConfiguracao(item.getIdItemConfiguracao());
			m.setIdProblema(item.getIdProblema());
			if (!this.getProblemaItemConfiguracaoDao().verificaSeCadastrado(m)) {
				this.getProblemaItemConfiguracaoDao().create(m);
			}
		}
	}

	public void relacaoIncidente(ItemConfiguracaoDTO item) throws ServiceException, Exception {
		/* Gravando o relacionamento com incidente */
		if (item.getIdIncidente() != null) {
			ItemCfgSolicitacaoServDTO m = new ItemCfgSolicitacaoServDTO();
			m.setIdItemConfiguracao(item.getIdItemConfiguracao());
			m.setIdSolicitacaoServico(item.getIdIncidente());
			m.setDataInicio(UtilDatas.getDataAtual());
			if (!this.getItemConfiguracaoSolicitacaoServicoDao().verificaSeCadastrado(m)) {
				this.getItemConfiguracaoSolicitacaoServicoDao().create(m);
			}
		}
	}

	@Override
	public void restaurarBaseline(ItemConfiguracaoDTO item, UsuarioDTO user) throws Exception {
		ItemConfiguracaoDTO itemConfiguracaoDto = new ItemConfiguracaoDTO();
		TransactionControler transactionControler = new TransactionControlerImpl(getDao().getAliasDB());
		this.getValorDao().setTransactionControler(transactionControler);

		this.getHistoricoItemConfiguracaoDao().setTransactionControler(transactionControler);

		HistoricoItemConfiguracaoDTO ic = new HistoricoItemConfiguracaoDTO();
		itemConfiguracaoDto = item;
		try {

			/* Gravando o historico */
			if (itemConfiguracaoDto.getIdItemConfiguracao() != null) {
				ic = (HistoricoItemConfiguracaoDTO) this.getHistoricoItemConfiguracaoDao().create(this.createHistoricoItem(itemConfiguracaoDto, user));
			}
			transactionControler.start();
			itemConfiguracaoDto.setDataInicio(UtilDatas.getDataAtual());
			getDao().update(itemConfiguracaoDto);
			this.getValorDao().deleteByIdItemConfiguracao(itemConfiguracaoDto.getIdItemConfiguracao());
			if (itemConfiguracaoDto.getValores() != null) {
				for (ValorDTO valorDto : itemConfiguracaoDto.getValores()) {
					this.getValorDao().create(valorDto);
					this.getHistoricoValorDao().create(this.createHistoricoValor(valorDto, user, ic.getIdHistoricoIC()));
				}
			}
			transactionControler.commit();

		} catch (Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(transactionControler, e);
		} finally {
			try {
				transactionControler.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
			}

		}
	}

	/* Historico de item configurao */
	@Override
	public HistoricoItemConfiguracaoDTO createHistoricoItem(ItemConfiguracaoDTO itemConfiguracao, UsuarioDTO user) throws Exception {
		HistoricoItemConfiguracaoDTO historico = new HistoricoItemConfiguracaoDTO();
		Reflexao.copyPropertyValues(itemConfiguracao, historico);

		DecimalFormat fmt = new DecimalFormat("0.0");
		HistoricoItemConfiguracaoDTO ultVersao = new HistoricoItemConfiguracaoDTO();
		ultVersao = this.getHistoricoItemConfiguracaoDao().maxIdHistorico(itemConfiguracao);
		if (ultVersao.getIdHistoricoIC() != null) {
			ultVersao = (HistoricoItemConfiguracaoDTO) this.getHistoricoItemConfiguracaoDao().restore(ultVersao);
			String sVersaoConvertida = fmt.format(ultVersao.getHistoricoVersao());
			historico.setHistoricoVersao(ultVersao.getHistoricoVersao() == null ? 1d : +new BigDecimal(Double.parseDouble(sVersaoConvertida.replace(",", ".")) + 0.1f).setScale(1, BigDecimal.ROUND_DOWN).floatValue());
		} else {
			historico.setHistoricoVersao(1d);
		}

		historico.setDataHoraAlteracao(UtilDatas.getDataHoraAtual());
		if (user != null) {
			if (user.getIdEmpregado() == null) {
				historico.setIdAutorAlteracao(1);
			} else {
				historico.setIdAutorAlteracao(user.getIdEmpregado());
			}

		} else {
			historico.setIdAutorAlteracao(1);
		}

		return historico;
	}

	/* Historico de valor item configurao */
	@Override
	public HistoricoValorDTO createHistoricoValor(ValorDTO valor, UsuarioDTO user, Integer idHistoricoIC) throws Exception {
		HistoricoValorDTO historico = new HistoricoValorDTO();
		Reflexao.copyPropertyValues(valor, historico);
		historico.setBaseLine("");
		historico.setIdHistoricoIC(idHistoricoIC);
		historico.setDataHoraAlteracao(UtilDatas.getDataHoraAtual());

		if (user == null) {
			historico.setIdAutorAlteracao(1);
		} else {
			historico.setIdAutorAlteracao(user.getIdEmpregado());
		}

		return historico;
	}

	@Override
	public void delete(IDto itemConfiguracao) throws ServiceException, LogicException {

		ItemConfiguracaoDTO itemConfiguracaoDto = new ItemConfiguracaoDTO();

		itemConfiguracaoDto = (ItemConfiguracaoDTO) itemConfiguracao;

		try {
			if (itemConfiguracaoDto.getIdItemConfiguracaoPai() == null) {

				TransactionControler transactionControler = new TransactionControlerImpl(getDao().getAliasDB());

				try {

					transactionControler.start();
					Collection<ItemConfiguracaoDTO> listItemConfiguracaoFilho = getDao().listItemConfiguracaoFilho(itemConfiguracaoDto);

					for (ItemConfiguracaoDTO itemConfiguracaoFilho : listItemConfiguracaoFilho) {

						itemConfiguracaoFilho = (ItemConfiguracaoDTO) this.restore(itemConfiguracaoFilho);
						itemConfiguracaoFilho.setDataFim(UtilDatas.getDataAtual());

						getDao().update(itemConfiguracaoFilho);
					}

					itemConfiguracaoDto.setDataFim(UtilDatas.getDataAtual());
					getDao().update(itemConfiguracaoDto);

					transactionControler.commit();

				} catch (Exception e) {

					e.printStackTrace();
					this.rollbackTransaction(transactionControler, e);

				} finally {
					try {
						transactionControler.close();
					} catch (PersistenceException e) {
						e.printStackTrace();
					}

				}
			} else {

				itemConfiguracaoDto.setDataFim(UtilDatas.getDataAtual());
				getDao().update(itemConfiguracaoDto);

			}

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	@Override
	public boolean validaDuplicidadeItemConfiguracao(ItemConfiguracaoDTO bean) throws Exception {
		return getDao().validaDuplicidadeItemConfiguracao(bean);
	}

	/**
	 * Retorna o Id da Empresa.
	 *
	 * @param request
	 * @return
	 */
	public static Integer getIdEmpresa(HttpServletRequest req) {
		UsuarioDTO usuario = WebUtil.getUsuario(req);
		return usuario.getIdEmpresa();
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listByGrupo(GrupoItemConfiguracaoDTO grupoICDto, String criticidade, String status) throws Exception {
		return getDao().listByGrupo(grupoICDto, criticidade, status);
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listByGrupo(GrupoItemConfiguracaoDTO grupoICDto, String criticidade, String status, Integer page, Integer pageSize) throws Exception {
		return getDao().listByGrupo(grupoICDto, criticidade, status, page, pageSize);
	}

	@Override
	public Integer sizeListByGrupo(GrupoItemConfiguracaoDTO grupoICDto, String criticidade, String status) throws Exception {
		return getDao().sizeListByGrupo(grupoICDto, criticidade, status);
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listByGrupo(GrupoItemConfiguracaoDTO grupoICDto, ItemConfiguracaoDTO itemConfiguracaoDTO) throws Exception {
		return getDao().listByGrupo(grupoICDto, itemConfiguracaoDTO);
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listItensSemGrupo(String criticidade, String status) throws Exception {
		return getDao().listItensSemGrupo(criticidade, status);
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listItensSemGrupo(String criticidade, String status, String sistemaOperacional, String grupoTrabalho, String tipoMembroDominio, String usuario, String processador, List softwares) throws Exception {
		return getDao().listItensSemGrupo(criticidade, status, sistemaOperacional, grupoTrabalho, tipoMembroDominio, usuario, processador, softwares);
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listItensSemGrupo(String criticidade, String status, String sistemaOperacional, String grupoTrabalho, String tipoMembroDominio, String usuario, String processador, List softwares, Integer page, Integer pageSize) throws Exception {
		return getDao().listItensSemGrupo(criticidade, status, sistemaOperacional, grupoTrabalho, tipoMembroDominio, usuario, processador, softwares, page, pageSize);
	}

	@Override
	public Integer sizelistItensSemGrupo(String criticidade, String status, String sistemaOperacional, String grupoTrabalho, String tipoMembroDominio, String usuario, String processador, List softwares) throws Exception {
		return getDao().sizelistItensSemGrupo(criticidade, status, sistemaOperacional, grupoTrabalho, tipoMembroDominio, usuario, processador, softwares);
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listItensSemGrupo(ItemConfiguracaoDTO itemConfiguracaoDTO) throws Exception {
		return getDao().listItensSemGrupo(itemConfiguracaoDTO);
	}

	@Override
	public void atualizaGrupo(ItemConfiguracaoDTO itemConfiguracaoDTO, UsuarioDTO user) throws Exception {

		TransactionControler transactionControler = new TransactionControlerImpl(getDao().getAliasDB());
		try {
			this.getHistoricoItemConfiguracaoDao().setTransactionControler(transactionControler);

			transactionControler.start();
			getDao().atualizaGrupo(itemConfiguracaoDTO);
			Collection<ItemConfiguracaoDTO> listItemConfiguracaoFilho = getDao().listItemConfiguracaoFilho(itemConfiguracaoDTO);

			for (ItemConfiguracaoDTO itemConfiguracaoFilho : listItemConfiguracaoFilho) {

				itemConfiguracaoFilho = (ItemConfiguracaoDTO) this.restore(itemConfiguracaoFilho);
				itemConfiguracaoFilho.setIdGrupoItemConfiguracao(itemConfiguracaoDTO.getIdGrupoItemConfiguracao());
				getDao().atualizaGrupo(itemConfiguracaoFilho);

			}
			itemConfiguracaoDTO = (ItemConfiguracaoDTO) this.restore(itemConfiguracaoDTO);

			enviarEmailNotificacao(itemConfiguracaoDTO, transactionControler, "ALT_IC_GRUPO");

			transactionControler.commit();

		} catch (Exception e) {
			e.printStackTrace();
			this.rollbackTransaction(transactionControler, e);
		} finally {
			try {
				transactionControler.close();
			} catch (PersistenceException e) {
				e.printStackTrace();
			}

		}

	}

	@Override
	public Collection<ItemConfiguracaoDTO> listByEvento(Integer idEvento) throws Exception {
		try {
			ItemConfiguracaoDao dao = getDao();
			return dao.listByEvento(idEvento);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public boolean VerificaSeCadastrado(ItemConfiguracaoDTO itemDTO) throws Exception {
		return getDao().VerificaSeCadastrado(itemDTO);
	}

	@Override
	public void updateNotNull(IDto dto) {
		try {
			validaUpdate(dto);
			getDao().updateNotNull(dto);
		} catch (ServiceException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public boolean verificaItemCriticos(Integer idItemConfiguracao) throws Exception {
		// TODO Melhorar cdigo pois esta deixando a tela lenta.

		RequisicaoMudancaDao requisicaoMudancaDao = new RequisicaoMudancaDao();
		ProblemaDAO problemaDao = new ProblemaDAO();
		SolicitacaoServicoDao solicitacaoServicoDao = new SolicitacaoServicoDao();

		List<RequisicaoMudancaDTO> listMudanca = requisicaoMudancaDao.listMudancaByIdItemConfiguracao(idItemConfiguracao);
		if (listMudanca != null && listMudanca.size() > 0) {
			return true;
		}

		List<SolicitacaoServicoDTO> listSolicitacao = solicitacaoServicoDao.listSolicitacaoServicoByItemConfiguracao(idItemConfiguracao);
		if (listSolicitacao != null && listSolicitacao.size() > 0) {
			return true;
		}

		List<ProblemaDTO> listProblema = problemaDao.listProblemaByIdItemConfiguracao(idItemConfiguracao);
		if (listProblema != null && listProblema.size() > 0) {
			return true;
		}

		return false;
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listByIdItemConfiguracaoPai(Integer idItemPai) throws Exception {
		try {
			ItemConfiguracaoDao dao = getDao();
			return dao.findByIdItemConfiguracaoPai(idItemPai);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<ItemConfiguracaoDTO> pesquisaDataExpiracao(Date data) throws Exception {
		return getDao().pesquisaDataExpiracao(data);
	}

	@Override
	public boolean verificaMidiaSoftware(Integer idMidiaSoftware) throws Exception {
		return getDao().verificaMidiaSoftware(idMidiaSoftware);
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listItemConfiguracaoByIdMudanca(Integer idMudanca) throws Exception {
		return getDao().listItemConfiguracaoByIdMudanca(idMudanca);
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listItemConfiguracaoByIdProblema(Integer problema) throws Exception {
		return getDao().listItemConfiguracaoByIdProblema(problema);
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listItemConfiguracaoByIdIncidente(Integer idIncidente) throws Exception {
		return getDao().listItemConfiguracaoByIdIncidente(idIncidente);
	}

	@Override
	public void enviarEmailNotificacao(ItemConfiguracaoDTO itemConfiguracaoDTO, TransactionControler transactionControler, String notificacao) throws Exception {

		EmpregadoDao empregadoDao = new EmpregadoDao();
		GrupoItemConfiguracaoDAO grupoItemConfiguracaoDAO = new GrupoItemConfiguracaoDAO();
		EmpregadoDTO emp = new EmpregadoDTO();
		GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();

		if (transactionControler != null) {
			empregadoDao.setTransactionControler(transactionControler);
		}

		String remetente = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SMTP_ENVIO_RemetenteNotificacoesSolicitacao, null);
		String ID_MODELO_EMAIL_AVISAR_CRIACAO_IC = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_MODELO_EMAIL_AVISAR_CRIACAO_IC, "16");
		String ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_IC = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_MODELO_EMAIL_AVISAR_ALTERACAO_IC, "14");
		String ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_IC_GRUPO = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_MODELO_EMAIL_AVISAR_ALTERACAO_IC_GRUPO, "15");
		String ID_MODELO_EMAIL = "";

		if (ID_MODELO_EMAIL_AVISAR_CRIACAO_IC == null || ID_MODELO_EMAIL_AVISAR_CRIACAO_IC.isEmpty()) {
			ID_MODELO_EMAIL_AVISAR_CRIACAO_IC = "16";
		}

		if (ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_IC == null || ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_IC.isEmpty()) {
			ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_IC = "14";
		}

		if (ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_IC_GRUPO == null || ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_IC_GRUPO.isEmpty()) {
			ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_IC_GRUPO = "15";
		}

		if (notificacao.equals("CRIA_IC")) {
			ID_MODELO_EMAIL = ID_MODELO_EMAIL_AVISAR_CRIACAO_IC;
		} else if (notificacao.equals("ALT_IC")) {
			ID_MODELO_EMAIL = ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_IC;
		} else if (notificacao.equals("ALT_IC_GRUPO")) {
			ID_MODELO_EMAIL = ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_IC_GRUPO;
		}

		if (!ID_MODELO_EMAIL.isEmpty()) {

			String PADRAO = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ENVIO_PADRAO_EMAIL_IC, "1");
			if (PADRAO == null || PADRAO.isEmpty()) {
				PADRAO = "1";
			}
			if (PADRAO.equals("1")) {
				// Enviando email para o grupo do IC
				if (itemConfiguracaoDTO.getIdGrupoItemConfiguracao() != null) {
					grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(itemConfiguracaoDTO.getIdGrupoItemConfiguracao());
					if (grupoItemConfiguracaoDAO.VerificaSeCadastrado(grupoItemConfiguracaoDTO)) {
						grupoItemConfiguracaoDTO = (GrupoItemConfiguracaoDTO) grupoItemConfiguracaoDAO.restore(grupoItemConfiguracaoDTO);
						itemConfiguracaoDTO.setNomeGrupoItemConfiguracao(grupoItemConfiguracaoDTO.getNomeGrupoItemConfiguracao());
					} else {
						grupoItemConfiguracaoDTO = null;
					}
				}
				if (grupoItemConfiguracaoDTO != null) {
					MensagemEmail mensagem = new MensagemEmail(Integer.parseInt(ID_MODELO_EMAIL.trim()), new IDto[] { itemConfiguracaoDTO });
					if (grupoItemConfiguracaoDTO.getEmailGrupoItemConfiguracao() != null) {
						mensagem.envia(grupoItemConfiguracaoDTO.getEmailGrupoItemConfiguracao(), "", remetente);
					}
				}
			} else if (PADRAO.equals("2")) {
				// Enviando email para o proprietrio do IC
				if (itemConfiguracaoDTO.getIdProprietario() != null) {
					emp.setIdEmpregado(itemConfiguracaoDTO.getIdProprietario());
					emp = (EmpregadoDTO) empregadoDao.restore(emp);
				}
				if (emp != null) {
					MensagemEmail mensagem = new MensagemEmail(Integer.parseInt(ID_MODELO_EMAIL), new IDto[] { itemConfiguracaoDTO });
					if (emp.getEmail() != null) {
						mensagem.envia(emp.getEmail(), "", remetente);
					}
				}
			} else if (PADRAO.equals("3")) {
				// Enviando email para o grupo do IC
				if (itemConfiguracaoDTO.getIdGrupoItemConfiguracao() != null) {
					grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(itemConfiguracaoDTO.getIdGrupoItemConfiguracao());
					if (grupoItemConfiguracaoDAO.VerificaSeCadastrado(grupoItemConfiguracaoDTO)) {
						grupoItemConfiguracaoDTO = (GrupoItemConfiguracaoDTO) grupoItemConfiguracaoDAO.restore(grupoItemConfiguracaoDTO);
						itemConfiguracaoDTO.setNomeGrupoItemConfiguracao(grupoItemConfiguracaoDTO.getNomeGrupoItemConfiguracao());
					} else {
						grupoItemConfiguracaoDTO = null;
					}
				}
				if (grupoItemConfiguracaoDTO != null) {
					MensagemEmail mensagem = new MensagemEmail(Integer.parseInt(ID_MODELO_EMAIL), new IDto[] { itemConfiguracaoDTO });
					if (grupoItemConfiguracaoDTO.getEmailGrupoItemConfiguracao() != null) {
						mensagem.envia(grupoItemConfiguracaoDTO.getEmailGrupoItemConfiguracao(), "", remetente);
					}
				}

				// Enviando email para o proprietrio do IC
				if (itemConfiguracaoDTO.getIdProprietario() != null) {
					emp.setIdEmpregado(itemConfiguracaoDTO.getIdProprietario());
					emp = (EmpregadoDTO) empregadoDao.restore(emp);
				}
				if (emp != null) {
					MensagemEmail mensagem = new MensagemEmail(Integer.parseInt(ID_MODELO_EMAIL), new IDto[] { itemConfiguracaoDTO });
					if (emp.getEmail() != null) {
						mensagem.envia(emp.getEmail(), "", remetente);
					}
				}
			}
		}

	}

	@Override
	public Collection<ItemConfiguracaoDTO> listaItemConfiguracaoPorBaseConhecimento(ItemConfiguracaoDTO itemConfiguracao) throws Exception {
		return getDao().listaItemConfiguracaoPorBaseConhecimento(itemConfiguracao);
	}

	@Override
	public Collection<ItemConfiguracaoDTO> quantidadeItemConfiguracaoPorBaseConhecimento(ItemConfiguracaoDTO itemConfiguracao) throws Exception {
		return getDao().quantidadeItemConfiguracaoPorBaseConhecimento(itemConfiguracao);
	}

	@Override
	public Collection findByConhecimento(BaseConhecimentoDTO baseConhecimentoDto) throws ServiceException, LogicException {
		try {
			return getDao().findByConhecimento(baseConhecimentoDto);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	public Collection findByIdItemConfiguracaoPai(Integer parm) throws Exception {
		return getDao().findByIdItemConfiguracaoPai(parm);
	}

	@Override
	public Integer quantidadeMidiaSoftware(ItemConfiguracaoDTO itemDTO) throws Exception {
		return getDao().quantidadeMidiaSoftware(itemDTO);
	}

	@Override
	public List<ItemConfiguracaoDTO> listaItemConfiguracaoOfficePak(ItemConfiguracaoDTO itemConfiguracaoDTO) throws Exception {
		// Desenvolvedor: ibimon.morais - Data: 17/08/2015 - Horrio: 08:31 - ID
		// Citsmart: 176362 -
		// Motivo/Comentrio: gerando a possibilidade de passar montar uma forma
		// de consulta em um banco espelhado, parametrizando o jdbc para
		// reports.
		return getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listaItemConfiguracaoOfficePak(itemConfiguracaoDTO);
	}

	@Override
	public List<ItemConfiguracaoDTO> listaItemConfiguracaoOfficePak(ItemConfiguracaoDTO itemConfiguracaoDTO, String chave) throws Exception {
		return getDao().listaItemConfiguracaoOfficePak(itemConfiguracaoDTO, chave);
	}

	@Override
	public void atualizaParaGrupoProducao(int idItem) throws ServiceException, Exception {

		Integer ID_CICLO_PRODUCAO_PADRAO = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_PRODUCAO_PADRAO, "1003").isEmpty() ? "1003" : ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_PRODUCAO_PADRAO, "1003"));
		Integer ID_CICLO_PRODUCAO = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_PRODUCAO, "998").isEmpty() ? "998" : ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_PRODUCAO, "998"));

		ItemConfiguracaoDTO itemDto = new ItemConfiguracaoDTO();
		itemDto.setIdItemConfiguracao(idItem);
		itemDto = (ItemConfiguracaoDTO) getDao().restore(itemDto);

		GrupoItemConfiguracaoDAO grupoDao = new GrupoItemConfiguracaoDAO();
		GrupoItemConfiguracaoDTO grupo = new GrupoItemConfiguracaoDTO();
		if (grupo != null && itemDto != null) {
			grupo.setIdGrupoItemConfiguracao(itemDto.getIdGrupoItemConfiguracao());
		}

		if (grupo != null && grupo.getIdGrupoItemConfiguracao() != null) {
			grupo = (GrupoItemConfiguracaoDTO) grupoDao.restore(grupo);
		}

		if (grupo != null) {
			if (grupo.getIdGrupoItemConfiguracaoPai() != null && grupo.getIdGrupoItemConfiguracaoPai().intValue() > 0) {
				if (grupo.getIdGrupoItemConfiguracaoPai().equals(ID_CICLO_PRODUCAO) || grupo.getIdGrupoItemConfiguracaoPai().equals(ID_CICLO_PRODUCAO_PADRAO)) {
					return;
				}
			}
		}

		if (itemDto != null) {
			if (itemDto.getIdGrupoItemConfiguracao() == null || !itemDto.getIdGrupoItemConfiguracao().equals(ID_CICLO_PRODUCAO_PADRAO)) {
				getDao().atualizaIdGrupoPadrao(itemDto, ID_CICLO_PRODUCAO_PADRAO);
			}
		}
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listItemConfiguracaoByIdLiberacao(Integer idLiberacao) throws Exception {
		return getDao().listItemConfiguracaoByIdLiberacao(idLiberacao);
	}

	public void relacaoLiberacao(ItemConfiguracaoDTO item) throws ServiceException, Exception {
		/* Gravando o relacionamento com liberao */
		if (item.getIdLiberacao() != null) {
			RequisicaoLiberacaoItemConfiguracaoDTO liberacao = new RequisicaoLiberacaoItemConfiguracaoDTO();
			liberacao.setIdItemConfiguracao(item.getIdItemConfiguracao());
			liberacao.setIdRequisicaoLiberacao(item.getIdLiberacao());
			if (!this.getRequisicaoLiberacaoItemConfiguracaoDao().verificaSeCadastrado(liberacao)) {
				this.getRequisicaoLiberacaoItemConfiguracaoDao().create(liberacao);
			}
		}
	}

	/*
	 * Historico de item configurao para ser chamado pelos modulo de
	 * liberacao, mudanca e problema para setar a origem da modificao
	 */
	@Override
	public void createHistoricoItemComOrigem(ItemConfiguracaoDTO itemConfiguracao, RequisicaoLiberacaoDTO liberacao, String origem) throws Exception {
		HistoricoItemConfiguracaoDTO historico = new HistoricoItemConfiguracaoDTO();
		UsuarioDTO user = new UsuarioDTO();
		Reflexao.copyPropertyValues(itemConfiguracao, historico);
		HistoricoItemConfiguracaoDAO dao = new HistoricoItemConfiguracaoDAO();

		user = liberacao.getUsuarioDto();

		historico.setOrigem(origem);
		historico.setIdOrigemModificacao(liberacao.getIdRequisicaoLiberacao());

		HistoricoItemConfiguracaoDTO ultVersao = new HistoricoItemConfiguracaoDTO();
		ultVersao = this.getHistoricoItemConfiguracaoDao().maxIdHistorico(itemConfiguracao);
		if (ultVersao.getIdHistoricoIC() != null) {
			ultVersao = (HistoricoItemConfiguracaoDTO) this.getHistoricoItemConfiguracaoDao().restore(ultVersao);
			historico.setHistoricoVersao(ultVersao.getHistoricoVersao() == null ? 1d : +new BigDecimal(ultVersao.getHistoricoVersao() + 0.1f).setScale(1, BigDecimal.ROUND_DOWN).floatValue());
		} else {
			historico.setHistoricoVersao(1d);
		}

		historico.setDataHoraAlteracao(UtilDatas.getDataHoraAtual());
		if (user != null) {
			if (user.getIdEmpregado() == null) {
				historico.setIdAutorAlteracao(1);
			} else {
				historico.setIdAutorAlteracao(user.getIdEmpregado());
			}

		} else {
			historico.setIdAutorAlteracao(1);
		}
		dao.create(historico);
	}

	public AuditoriaItemConfigDTO gravarAuditoriaItemConfig(ItemConfiguracaoDTO itemConfiguracaoDTO, HistoricoValorDTO historicoValorDTO, ValorDTO valorDto, UsuarioDTO usr, String tipoAlteracao) {
		AuditoriaItemConfigDTO auditoriaItemConfigDTO = new AuditoriaItemConfigDTO();

		try {

			if (itemConfiguracaoDTO != null && itemConfiguracaoDTO.getIdItemConfiguracao() != null) {

				if (itemConfiguracaoDTO.getHistoricoItemConfiguracaoDTO() != null) {
					auditoriaItemConfigDTO.setIdHistoricoIC(itemConfiguracaoDTO.getHistoricoItemConfiguracaoDTO().getIdHistoricoIC());
				}

				auditoriaItemConfigDTO.setIdItemConfiguracao(itemConfiguracaoDTO.getIdItemConfiguracao());
				auditoriaItemConfigDTO.setIdItemConfiguracaoPai(itemConfiguracaoDTO.getIdItemConfiguracaoPai());
				if (auditoriaItemConfigDTO.getIdHistoricoValor() != null) {
					auditoriaItemConfigDTO.setIdHistoricoValor(auditoriaItemConfigDTO.getIdHistoricoValor());
				}

				if (itemConfiguracaoDTO.getIdTipoItemConfiguracao() != null) {
					auditoriaItemConfigDTO.setIdTipoItemConfiguracao(itemConfiguracaoDTO.getIdTipoItemConfiguracao());
			}
			}

			if (usr != null && usr.getIdUsuario() != null) {
				auditoriaItemConfigDTO.setIdUsuario(usr.getIdUsuario());
			}

			if (tipoAlteracao != null) {
				auditoriaItemConfigDTO.setTipoAlteracao(tipoAlteracao);
			}

			if (historicoValorDTO != null && historicoValorDTO.getIdHistoricoValor() != null) {
				auditoriaItemConfigDTO.setIdHistoricoValor(historicoValorDTO.getIdHistoricoValor());
				auditoriaItemConfigDTO.setIdHistoricoIC(historicoValorDTO.getIdHistoricoIC());
			}

			if (valorDto != null && valorDto.getIdValor() != null) {
				auditoriaItemConfigDTO.setIdHistoricoValor(valorDto.getIdValor());
			}

			auditoriaItemConfigDTO.setDataHoraAlteracao(UtilDatas.getDataHoraAtual());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return auditoriaItemConfigDTO;
	}

	public void finalizarItemConfiguracao(ItemConfiguracaoDTO itemConfiguracaoDto, TransactionControler tc) {
		try {
			if (itemConfiguracaoDto != null && itemConfiguracaoDto.getIdItemConfiguracao() != null) {
				getDao().setTransactionControler(tc);
				itemConfiguracaoDto.setDataExpiracao(UtilDatas.getDataAtual());
				getDao().finalizarItemConfiguracao(itemConfiguracaoDto);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public List<AuditoriaItemConfigDTO> historicoAlteracaoItemConfiguracaoByIdItemConfiguracao(ItemConfiguracaoDTO itemConfiguracaoDTO) throws Exception {
		return getAuditoriaItemConfiguracaoDao().historicoAlteracaoItemConfiguracaoByIdItemConfiguracao(itemConfiguracaoDTO);
	}

	/**
	 *
	 * necessario passar a data de finalizao
	 *
	 * @param itemConfiguracaoDTO
	 * @return lista de item configurao finalizados "Desistalando"
	 * @throws Exception
	 */
	public List<ItemConfiguracaoDTO> retornaItemConfiguracaoFinalizadoByIdItemConfiguracao(ItemConfiguracaoDTO itemConfiguracaoDTO) throws Exception {
		return getDao().listItemConfiguracaoFinalizadosByIdItemconfiguracao(itemConfiguracaoDTO);
	}

	@Override
	public boolean atualizaStatus(Integer item, Integer status) {
		return getDao().atualizaStatus(item, status);
	}

	@Override
	public ItemConfiguracaoDTO obterICFilhoPorIdentificacaoIdPaiEIdTipo(ItemConfiguracaoDTO itemConfiguracaoDTO) throws Exception {
		try {
			return this.getDao().obterICFilhoPorIdentificacaoIdPaiEIdTipo(itemConfiguracaoDTO);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public ItemConfiguracaoDTO findByIdentificacaoItemConfiguracao(ItemConfiguracaoDTO itemConfiguracaoDTO) throws Exception {
		try {
			ItemConfiguracaoDao dao = getDao();
			return dao.findByIdentificacaoItemConfiguracao(itemConfiguracaoDTO);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public ItemConfiguracaoDTO findByIdentificacao(String identificacao) throws Exception {
		try {
			return getDao().findByIdentificacao(identificacao);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listByIdGrupoAndTipoItemAndIdItemPaiAtivos(Integer idGrupo, Integer idTipo, Integer idPai) throws Exception {
		try {
			ItemConfiguracaoDao dao = getDao();
			return dao.listByIdGrupoAndTipoItemAndIdItemPaiAtivos(idGrupo, idTipo, idPai);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listByIdItemPaiAndTagTipoItemCfg(Integer idItemConfiguracaoPai, String tagTipoCfg) throws Exception {
		return getDao().listByIdItemPaiAndTagTipoItemCfg(idItemConfiguracaoPai, tagTipoCfg);
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listAtivos() throws Exception {
		return getDao().listAtivos();
	}

	@Override
	public Collection<ItemConfiguracaoDTO> listByIdentificacao(String identif) throws Exception {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("identificacao", "like", "%" + identif + "%"));
		condicao.add(new Condition("idItemConfiguracaoPai", "IS", null));

		ordenacao.add(new Order("idItemConfiguracaoPai"));
		List<ItemConfiguracaoDTO> lstItemCongConfiguracaoPai = (List) getDao().findByCondition(condicao, ordenacao);

		return lstItemCongConfiguracaoPai;
	}

	/**
	 * Obtem a Identificao do Item de Configurao de acordo com os valores
	 * das caractersticas que o identifica como nico.
	 *
	 * @param tipoItemConfiguracaoDTO
	 *            - Tipo do Item de Configurao com suas devidas
	 *            caractersticas e valores.
	 * @return String - Identificao do Item de Configurao.
	 * @author valdoilo.damasceno
	 * @since 19.01.2015
	 */
	public String obterIdentificacaoItemConfiguracaoFilho(TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO) {

		try {

			TagTipoItemConfiguracaoDefault tagTipoItemConfiguracaoDefault = TagTipoItemConfiguracaoDefault.valueOf(tipoItemConfiguracaoDTO.getTag());

			switch (tagTipoItemConfiguracaoDefault) {
			case HARDWARE:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.NAME.name(), CaracteristicaIdentificacao.IPADDR.name());
			case BIOS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.SMANUFACTURER.name(), CaracteristicaIdentificacao.SSN.name());
			case MEMORIES:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.CAPTION.name(), CaracteristicaIdentificacao.SERIALNUMBER.name(), CaracteristicaIdentificacao.CAPACITY.name());
			case INPUTS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.TYPE.name(), CaracteristicaIdentificacao.DEVICEID.name());
			case ACCOUNTS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.DOMAIN.name(), CaracteristicaIdentificacao.NAME.name());
			case ENVIRONMENTS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.USERNAME.name(), CaracteristicaIdentificacao.NAME.name());
			case SERVICES:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.CAPTION.name(), CaracteristicaIdentificacao.STARTMODE.name());
			case STORAGES:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.NAME.name(), CaracteristicaIdentificacao.TYPE.name(), CaracteristicaIdentificacao.DISKSIZE.name());
			case NETWORKS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.DESCRIPTION.name(), CaracteristicaIdentificacao.MACADDR.name());
			case SOFTWARES:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.NAME.name(), CaracteristicaIdentificacao.VERSION.name());
			case OFFICEPACK:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.PRODUCT.name(), CaracteristicaIdentificacao.PRODUCTID.name());
			case CAPTION:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.SMANUFACTURER.name(), CaracteristicaIdentificacao.SSN.name());
			case PORTS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.NAME.name(), CaracteristicaIdentificacao.CAPTION.name());
			case CONTROLLERS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.NAME.name(), CaracteristicaIdentificacao.MANUFACTURER.name());
			case SLOTS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.NAME.name(), CaracteristicaIdentificacao.DESCRIPTION.name());
			case SOUNDS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.NAME.name(), CaracteristicaIdentificacao.MANUFACTURER.name());
			case DRIVES:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.LETTER.name(), CaracteristicaIdentificacao.TYPE.name(), CaracteristicaIdentificacao.TOTAL.name());
			case VIDEOS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.NAME.name(), CaracteristicaIdentificacao.MEMORY.name());
			case MONITORS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.MANUFACTURER.name(), CaracteristicaIdentificacao.SERIAL.name());
			case PRINTERS:
				return this.obterIdentificacao(tipoItemConfiguracaoDTO.getCaracteristicas(), CaracteristicaIdentificacao.NAME.name(), CaracteristicaIdentificacao.DRIVER.name());
			default:
				LOGGER.info("TIPO ITEM CONFIGURAO NO POSSUI IDENTIFICAO PADRO: " + tipoItemConfiguracaoDTO.getTag());
				return ((CaracteristicaDTO) tipoItemConfiguracaoDTO.getCaracteristicas().get(0)).getValorString();
			}
		} catch (Exception e) {
			LOGGER.info("TIPO ITEM CONFIGURAO IDENTIFICADO: " + tipoItemConfiguracaoDTO.getTag());
			return "No identificado";
		}
	}

	/**
	 * Obtm a Identificao do Item de Configurao identificacao =
	 * valorCaracterstica1 + valorCaracterstica2.
	 *
	 * @param listCaracteristicaDto
	 *            - Lista de caractersticas.
	 * @param tagCaracteristica1
	 *            - TAG da Caracterstica 1 de Identificao.
	 * @param tagCaracteristica2
	 *            - TAG da Caracterstica 2 de Identificao.
	 * @return String - Identificao do Item de Configurao de acordo com as
	 *         TAGs informadas.
	 * @author valdoilo.damasceno
	 * @since 19.01.2015
	 */
	private String obterIdentificacao(List<CaracteristicaDTO> listCaracteristicaDto, final String tagCaracteristica1, final String tagCaracteristica2) {
		StringBuilder nome1 = new StringBuilder();
		StringBuilder nome2 = new StringBuilder();

		if (listCaracteristicaDto != null && !listCaracteristicaDto.isEmpty()) {

			for (CaracteristicaDTO caracteristicaDto : listCaracteristicaDto) {
				try {
					CaracteristicaIdentificacao caracteristicaIdentificacao = CaracteristicaIdentificacao.valueOf(caracteristicaDto.getTag());
					if (caracteristicaIdentificacao != null && (nome1.toString().isEmpty() || nome2.toString().isEmpty()) && caracteristicaIdentificacao.getNomeCaracteristica().equals(tagCaracteristica1)) {
						nome1.append(caracteristicaDto.getValor().getValorStr() + " - ");
					} else {
						if (caracteristicaIdentificacao != null && (nome1.toString().isEmpty() || nome2.toString().isEmpty()) && caracteristicaIdentificacao.getNomeCaracteristica().equals(tagCaracteristica2)) {
							nome2.append(caracteristicaDto.getValor().getValorStr());
						}
					}
				} catch (Exception e) {
					/** Tag do Item de Configurao no  chave, prosseguir **/
				}
			}

			return nome1.toString() + nome2.toString();
		}

		return "No Identificado ";
	}

	/**
	 * Obtm a Identificao do Item de Configurao identificacao =
	 * valorCaracterstica1 + valorCaracterstica2 + valorCaracterstica3.
	 *
	 * @param listCaracteristicaDto
	 *            - Lista de caractersticas.
	 * @param tagCaracteristica1
	 *            - TAG da Caracterstica 1 de Identificao.
	 * @param tagCaracteristica2
	 *            - TAG da Caracterstica 2 de Identificao.
	 * @param tagCaracteristica3
	 *            - TAG da Caracterstica 3 de Identificao.
	 * @return String - Identificao do Item de Configurao de acordo com as
	 *         TAGs informadas.
	 * @author valdoilo.damasceno
	 * @since 19.01.2015
	 */
	private String obterIdentificacao(List<CaracteristicaDTO> listCaracteristicaDto, final String tagCaracteristica1, final String tagCaracteristica2, final String tagCaracteristica3) {
		StringBuilder nome1 = new StringBuilder();
		StringBuilder nome2 = new StringBuilder();
		StringBuilder nome3 = new StringBuilder();

		if (listCaracteristicaDto != null && !listCaracteristicaDto.isEmpty()) {

			for (CaracteristicaDTO caracteristicaDto : listCaracteristicaDto) {
				try {
					CaracteristicaIdentificacao caracteristicaIdentificacao = CaracteristicaIdentificacao.valueOf(caracteristicaDto.getTag());
					if (caracteristicaIdentificacao != null && (nome1.toString().isEmpty() || nome2.toString().isEmpty() || nome3.toString().isEmpty())) {
						if (caracteristicaIdentificacao.getNomeCaracteristica().equals(tagCaracteristica1)) {
							nome1.append(caracteristicaDto.getValor().getValorStr() + " - ");
						} else if (caracteristicaIdentificacao.getNomeCaracteristica().equals(tagCaracteristica2)) {
							nome2.append(caracteristicaDto.getValor().getValorStr() + " - ");
						} else if (caracteristicaIdentificacao.getNomeCaracteristica().equals(tagCaracteristica3)) {
							if (caracteristicaIdentificacao.getNomeCaracteristica().equals("DISKSIZE") || caracteristicaIdentificacao.getNomeCaracteristica().equals("CAPACITY") || caracteristicaIdentificacao.getNomeCaracteristica().equals("TOTAL")) {
								try {
									Double tamanho = Double.parseDouble(caracteristicaDto.getValor().getValorStr());
									tamanho /= Math.pow(1024, 3);
									nome3.append(new DecimalFormat(".00").format(tamanho).toString() + " GB");
								} catch (NumberFormatException e) {
									/**
									 * Valor no-numrico no campo de capacidade
									 * ou tamanho de disco. Retornar valor
									 * deste.
									 **/
									nome3.append(caracteristicaDto.getValor().getValorStr());
								}
							} else {
								nome3.append("SIZE UNKNOWN");
							}
						} else {

							if (!nome1.toString().isEmpty() && !nome2.toString().isEmpty() && !nome3.toString().isEmpty()) {
								return nome1.toString() + nome2.toString() + nome3.toString();
							}
						}
					}
				} catch (Exception e) {

				}
			}
		}
		if (!nome1.toString().isEmpty() || !nome2.toString().isEmpty() || !nome3.toString().isEmpty()) {
			return nome1.toString() + nome2.toString() + nome3.toString();
		} else {
			return "No Identificado ";
		}
	}

	@Override
	public ItemConfiguracaoDTO findByIdItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		return this.getDao().findByIdItemConfiguracao(idItemConfiguracao);
	}

	@Override
	public String getIdentificadorItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		String identificacao = "";
		if (idItemConfiguracao != null && idItemConfiguracao.intValue() != 0) {
			ItemConfiguracaoDTO itemConfiguracaoPai = this.findByIdItemConfiguracao(idItemConfiguracao);
			if (itemConfiguracaoPai != null && itemConfiguracaoPai.getIdentificacao() != null) {
				identificacao = itemConfiguracaoPai.getIdentificacao();
			}
		}
		return identificacao;
	}

	@Override
	public List<ItemConfiguracaoDTO> listItensByGerenciamentoItemConfiguracaoDTO(GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO) throws Exception {
		return getDao().listItensByGerenciamentoItemConfiguracaoDTO(gerenciamentoItemConfiguracaoDTO);
	}

	@Override
	public int getQuantidadeIncidentesTotalItem() throws Exception {
		return getDao().getQuantidadeIncidentesTotalItem();
	}

	@Override
	public int getQuantidadeMudancasTotalItem() throws Exception {
		return getDao().getQuantidadeMudancasTotalItem();
	}

	@Override
	public int getQuantidadeProblemasTotalItem() throws Exception {
		return getDao().getQuantidadeProblemasTotalItem();
	}

	@Override
	public int getQuantidadeLiberacoesTotalItem() throws Exception {
		return getDao().getQuantidadeLiberacoesTotalItem();
	}

	/**
	 * Procura ICs pelo ID do Proprietario
	 *
	 * @author gilberto.nery
	 * @since 05/11/2015
	 * @param idProprietario
	 * @return
	 * @throws Exception
	 */
	@Override
	public Collection<ItemConfiguracaoDTO> findByIdProprietario(Integer idProprietario) throws Exception {
		return getDao().getICPeloProprietario(idProprietario);
	}

	@Override
	public ItemConfiguracaoDTO findByIdItemConfiguracaoPaiAndIdentificacao(Integer idItemConfiguracaoPai, String identificacao) throws Exception {
		return (ItemConfiguracaoDTO) getDao().findByIdItemConfiguracaoPaiAndIdentificacao(idItemConfiguracaoPai, identificacao);
	}

	@Override
	public List<ItemConfiguracaoDTO> listItemConfiguracaoCriticidadeAltaECriticaComCalendario() throws Exception {
		return getDao().listItemConfiguracaoCriticidadeAltaECriticaComCalendario();
	}
}