package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ItemConfiguracaoValorDTO;
import br.com.centralit.citcorpore.integracao.ItemConfiguracaoValorDao;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings({"unchecked", "rawtypes"})
public class ItemConfiguracaoValorServiceEjb extends CrudServiceImpl implements ItemConfiguracaoValorService{

	private ItemConfiguracaoValorDao itemConfiguracaoValorDao;
	
	@Override
	protected ItemConfiguracaoValorDao getDao() {
		if(itemConfiguracaoValorDao == null)
			itemConfiguracaoValorDao = new ItemConfiguracaoValorDao();
		return itemConfiguracaoValorDao;
	}
	
	@Override
	public Collection listByIdItemConfiguracao(ItemConfiguracaoValorDTO itemConfiguracaoValorDTO) throws Exception {
		return getDao().listByIdItemConfiguracao(itemConfiguracaoValorDTO);
	}

	@Override
	public Integer getNumeroPaginasByIdItemConfiguracao(ItemConfiguracaoValorDTO itemConfiguracaoValorDTO, Integer pageSize)
			throws Exception {
		try{
			Double total = new Double(getDao().listByIdItemConfiguracao(itemConfiguracaoValorDTO).size());
			Double size = new Double(pageSize);
			total = Math.ceil(total / pageSize);
			return total.intValue();
		} catch (Exception e){
			return 0;
		}
	}

	@Override
	public List<ItemConfiguracaoValorDTO> listByIdItemConfiguracaoPaginado(
			ItemConfiguracaoValorDTO itemConfiguracaoValorDTO) throws Exception {
		return getDao().listByIdItemConfiguracaoPaginado(itemConfiguracaoValorDTO);
	}

}
