package br.com.centralit.citcorpore.negocio;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.JornadaTrabalhoDTO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

public interface JornadaTrabalhoService extends CrudService {

	/**
	 * Exclui jornada caso a mesma no esteja sendo utilizada no calendrio.
	 *
	 * @param model
	 * @param document
	 * @throws ServiceException
	 * @throws Exception
	 */
	public String deletarJornada(Integer idJornada) throws ServiceException, Exception;

	/**
	 * Consultar jornadas ativas
	 *
	 * @return retorna a lista de jornadas que esto ativas
	 * @throws Exception
	 * @author rodrigo.oliveira
	 */

	public Collection<JornadaTrabalhoDTO> listarJornadasAtivas() throws Exception;

	/**
	 * Verifica jornada existente
	 *
	 * @param JornadaTrabalhoDTO
	 * @return retorna true se caso exista jornada j cadastrada
	 * @throws Exception
	 * @author rodrigo.oliveira
	 */
	public boolean verificaJornadaExistente(JornadaTrabalhoDTO jornadaTrabalho) throws Exception;

}
