package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.integracao.LiberacaoMudancaDao;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("rawtypes")
public class LiberacaoMudancaServiceEjb extends CrudServiceImpl implements LiberacaoMudancaService {

    private LiberacaoMudancaDao dao;

    @Override
    protected LiberacaoMudancaDao getDao() {
        if (dao == null) {
            dao = new LiberacaoMudancaDao();
        }
        return dao;
    }

    @Override
    public Collection findByIdLiberacao(final Integer parm) throws Exception {
        try {
            return this.getDao().findByIdLiberacao(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void deleteByIdLiberacao(final Integer parm) throws Exception {
        try {
            this.getDao().deleteByIdLiberacao(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public Collection findByIdRequisicaoMudanca(final Integer idLiberacao, final Integer idRequisicaoMudanca) throws Exception {
        try {
            return this.getDao().findByIdRequisicaoMudanca(idLiberacao, idRequisicaoMudanca);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

}
