package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.MatrizContratoDTO;
import br.com.centralit.citcorpore.integracao.GrupoDao;
import br.com.centralit.citcorpore.integracao.MatrizContratoDao;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

/**
 * @author ibimon.morais
 * @25/09/2015
 */
@SuppressWarnings("unchecked")
public class MatrizContratoServiceEjb extends CrudServiceImpl implements MatrizContratoService {

	private MatrizContratoDao dao;

	/**
	 * @author ibimon.morais
	 */
	@Override
	protected MatrizContratoDao getDao() {
		if (this.dao == null) {
			this.dao = new MatrizContratoDao();
		}
		return this.dao;
	}

	/**
	 * @author ibimon.morais
	 * @25/09/2015
	 */
	@Override
	public Collection<MatrizContratoDTO> findByIdContrato(final Integer idContrato) throws Exception {
		try {
			final Collection<MatrizContratoDTO> lista = this.getDao().findByIdContrato(idContrato);
			if (lista != null && !lista.isEmpty()) {
				for (final MatrizContratoDTO dto : lista) {
					this.obterDescricaoComunicacaoGrupoEnvolvido(dto);
				}
			}
			return lista;
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	private void obterDescricaoComunicacaoGrupoEnvolvido(final MatrizContratoDTO dto) throws PersistenceException {
		if (dto.getGrupoEnvolvido() != null) {
			final GrupoDao grupoDao = new GrupoDao();
			GrupoDTO grupoDto = new GrupoDTO();
			grupoDto.setIdGrupo(dto.getGrupoEnvolvido());
			grupoDto = (GrupoDTO) grupoDao.restore(grupoDto);
			dto.setNomeGrupoEnvolvido(grupoDto.getNome());
		}
	}
}
