package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.MudancaBaseConhecimentoDTO;
import br.com.centralit.citcorpore.integracao.MudancaBaseConhecimentoDao;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class MudancaBaseConhecimentoServiceEjb extends CrudServiceImpl implements MudancaBaseConhecimentoService {

    private MudancaBaseConhecimentoDao dao;

    @Override
    protected MudancaBaseConhecimentoDao getDao() {
        if (dao == null) {
            dao = new MudancaBaseConhecimentoDao();
        }
        return dao;
    }

    @Override
    public Collection findByIdConhecimento(final Integer parm) throws Exception {
        try {
            return this.getDao().findByIdConhecimento(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void deleteByIdBaseConhecimento(final Integer parm) throws Exception {
        try {
            this.getDao().deleteByIdBaseConhecimento(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    /**
     * Lista por idrequisicaoliberacao, no caso ele listar apenas os que o status no for nulo.
     * 
     * @author geber.costa
     * @param idrequisicaoliberacao
     * @return
     * @throws ServiceException
     * @throws Exception
     *
     */
    @Override
    public Collection<MudancaBaseConhecimentoDTO> listAll() throws ServiceException, Exception {
        try {
            return this.getDao().listAll();
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public Collection findByIdRequisicaoMudanca(final Integer idRequisicaoMudanca) throws Exception {
        try {
            return this.getDao().findByIdRequisicaoMudanca(idRequisicaoMudanca);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

}
