package br.com.centralit.citcorpore.negocio;

import java.util.List;

import br.com.centralit.citcorpore.bean.ObjetivoPlanoMelhoriaDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.service.CrudService;

@SuppressWarnings("rawtypes")
public interface ObjetivoPlanoMelhoriaService extends CrudService {

	public List<ObjetivoPlanoMelhoriaDTO> findByIdPlanoMelhoria(Integer parm) throws Exception;

	public void deleteByIdPlanoMelhoria(Integer parm) throws Exception;

	/**
	 * Retorna uma lista de objetivos de acordo com o plano de medida passado
	 * 
	 * @param obj
	 * @return
	 * @throws Exception
	 * @author thays.araujo
	 */
	public List<ObjetivoPlanoMelhoriaDTO> listObjetivosPlanoMelhoria(Integer idPlanoMelhoria) throws Exception;

	public List<IDto> listObjetivosPlanoMelhoriaAsIDto(Integer idPlanoMelhoria) throws Exception;

	public boolean hasVinculoComPlanoMelhoria(Integer idPlanoMelhoria) throws PersistenceException;
}
