package br.com.centralit.citcorpore.negocio;

import java.util.List;

import br.com.centralit.citcorpore.bean.ObjetivoPlanoMelhoriaDTO;
import br.com.centralit.citcorpore.integracao.ObjetivoPlanoMelhoriaDao;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("rawtypes")
public class ObjetivoPlanoMelhoriaServiceEjb extends CrudServiceImpl implements ObjetivoPlanoMelhoriaService {

    private ObjetivoPlanoMelhoriaDao dao;

    @Override
    protected ObjetivoPlanoMelhoriaDao getDao() {
        if (dao == null) {
            dao = new ObjetivoPlanoMelhoriaDao();
        }
        return dao;
    }

    @Override
	public List<ObjetivoPlanoMelhoriaDTO> findByIdPlanoMelhoria(final Integer parm) throws Exception {
        try {
            return this.getDao().findByIdPlanoMelhoria(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

	public boolean hasVinculoComPlanoMelhoria(Integer idPlanoMelhoria) throws PersistenceException {
		return this.getDao().hasVinculoComPlanoMelhoria(idPlanoMelhoria);
	}

    @Override
    public void deleteByIdPlanoMelhoria(final Integer parm) throws Exception {
        try {
            this.getDao().deleteByIdPlanoMelhoria(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
	public List<ObjetivoPlanoMelhoriaDTO> listObjetivosPlanoMelhoria(final Integer idPlanoMelhoria) throws Exception {
        try {
			return this.getDao().listObjetivosPlanoMelhoria(idPlanoMelhoria);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

	@Override
	public List<IDto> listObjetivosPlanoMelhoriaAsIDto(final Integer idPlanoMelhoria) throws Exception {
		try {
			return this.getDao().listObjetivosPlanoMelhoriaAsIDto(idPlanoMelhoria);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

}
