package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoAnexosDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoAnexosDAO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoAnexosServiceEjb extends CrudServiceImpl implements OcorrenciaServicoAnexosService {

	private OcorrenciaServicoAnexosDAO ocorrenciaServicoAnexosDAO;

	@Override
	protected OcorrenciaServicoAnexosDAO getDao() {
		if (this.ocorrenciaServicoAnexosDAO == null) {
			this.ocorrenciaServicoAnexosDAO = new OcorrenciaServicoAnexosDAO();
		}
		return this.ocorrenciaServicoAnexosDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoAnexosDTO> findOcorrenciaServicoAnexosByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoAnexosByIdOcorrenciaServico(idOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public void createOcorrenciaServicoAnexos(final OcorrenciaServicoDTO ocorrenciaServicoDTO, final List<Integer> listaIdsAnexos, final String acaoOcorrenciaServico) throws Exception {
		try {
			this.getDao().createOcorrenciaServicoAnexos(ocorrenciaServicoDTO, listaIdsAnexos, acaoOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public void createOcorrenciaServicoAnexosRemovido(final Integer idOcorrenciaServico, final UploadDTO anexoRemovido) throws Exception {
		try {
			if (anexoRemovido != null) {
				OcorrenciaServicoAnexosDTO ocorrenciaServicoAnexosRemovido = new OcorrenciaServicoAnexosDTO();
				ocorrenciaServicoAnexosRemovido.setIdOcorrenciaServico(idOcorrenciaServico);
				ocorrenciaServicoAnexosRemovido.setAcaoOcorrenciaServico(AuditoriaAcoes.REMOVIDO.getIdentificador());
				ocorrenciaServicoAnexosRemovido.setIdAnexoOcorrenciaServico(anexoRemovido.getIdControleGED());
				ocorrenciaServicoAnexosRemovido.setNomeAnexoOcorrenciaServico(anexoRemovido.getNameFile());
				ocorrenciaServicoAnexosRemovido.setDescricaoAnexoOcorrenciaServico(anexoRemovido.getDescricao());
				this.getDao().create(ocorrenciaServicoAnexosRemovido);
			}
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}
}
