package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoAplicacaoDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoAplicacaoDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoAplicacaoServiceEjb extends CrudServiceImpl implements OcorrenciaServicoAplicacaoService {

	private OcorrenciaServicoAplicacaoDAO ocorrenciaServicoAplicacaoDAO;

	@Override
	protected OcorrenciaServicoAplicacaoDAO getDao() {
		if (this.ocorrenciaServicoAplicacaoDAO == null) {
			this.ocorrenciaServicoAplicacaoDAO = new OcorrenciaServicoAplicacaoDAO();
		}
		return this.ocorrenciaServicoAplicacaoDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoAplicacaoDTO> findOcorrenciaServicoAplicacaoByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoAplicacaoByIdOcorrenciaServico(idOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public void createOcorrenciaServicoAplicacao(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico, final String acaoOcorrenciaServico) throws Exception {
		try {
			this.getDao().createOcorrenciaServicoAplicacao(idOcorrenciaServico, listaIdsOcorrenciaServico, acaoOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}
}
