package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AtributosFinanceirosDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoAtributosFinanceirosDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoAtributosFinanceirosDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoAtributosFinanceirosServiceEjb extends CrudServiceImpl implements OcorrenciaServicoAtributosFinanceirosService {

	private OcorrenciaServicoAtributosFinanceirosDAO ocorrenciaServicoAtributosFinanceirosDAO;

	@Override
	protected OcorrenciaServicoAtributosFinanceirosDAO getDao() {
		if (this.ocorrenciaServicoAtributosFinanceirosDAO == null) {
			this.ocorrenciaServicoAtributosFinanceirosDAO = new OcorrenciaServicoAtributosFinanceirosDAO();
		}
		return this.ocorrenciaServicoAtributosFinanceirosDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoAtributosFinanceirosDTO> findOcorrenciaServicoAtributosFinanceirosByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoAtributosFinanceirosByIdOcorrenciaServico(idOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public void createOcorrenciaServicoAtributosFinanceiros(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico,
			final AtributosFinanceirosDTO atributosFinanceirosOcorrenciaServico) throws Exception {
		try {
			this.getDao().createOcorrenciaServicoAtributosFinanceiros(idOcorrenciaServico, listaIdsOcorrenciaServico, atributosFinanceirosOcorrenciaServico);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

}
