package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoBaseConhecimentoDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoBaseConhecimentoServiceEjb extends CrudServiceImpl implements OcorrenciaServicoBaseConhecimentoService {

	private OcorrenciaServicoBaseConhecimentoDAO ocorrenciaServicoBaseConhecimentoDAO;

	@Override
	protected OcorrenciaServicoBaseConhecimentoDAO getDao() {
		if (this.ocorrenciaServicoBaseConhecimentoDAO == null) {
			this.ocorrenciaServicoBaseConhecimentoDAO = new OcorrenciaServicoBaseConhecimentoDAO();
		}
		return this.ocorrenciaServicoBaseConhecimentoDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoBaseConhecimentoDTO> findOcorrenciaServicoBaseConhecimentoByIdOcorrenciaServico(Integer idOcorrenciaServico) throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoBaseConhecimentoByIdOcorrenciaServico(idOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	@Override
	public void createOcorrenciaServicoBaseConhecimento(Integer idOcorrenciaServico, List<Integer> listaIdsOcorrenciaServico, String acaoOcorrenciaServico) throws Exception {
		try {
			this.getDao().createOcorrenciaServicoBaseConhecimento(idOcorrenciaServico, listaIdsOcorrenciaServico, acaoOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}
}
