package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoContratoDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoContratoDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoContratoServiceEjb extends CrudServiceImpl implements OcorrenciaServicoContratoService {

	private OcorrenciaServicoContratoDAO ocorrenciaServicoContratoDAO;

	@Override
	protected OcorrenciaServicoContratoDAO getDao() {
		if (this.ocorrenciaServicoContratoDAO == null) {
			this.ocorrenciaServicoContratoDAO = new OcorrenciaServicoContratoDAO();
		}
		return this.ocorrenciaServicoContratoDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoContratoDTO> findOcorrenciaServicoContratoByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoContratoByIdOcorrenciaServico(idOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public void createOcorrenciaServicoContrato(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico, final String acaoOcorrenciaServico) throws Exception {
		try {
			this.getDao().createOcorrenciaServicoContrato(idOcorrenciaServico, listaIdsOcorrenciaServico, acaoOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}
}
