package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.DonoNegocioDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDonoNegocioDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoDonoNegocioDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoDonoNegocioServiceEjb extends CrudServiceImpl implements OcorrenciaServicoDonoNegocioService {

	private OcorrenciaServicoDonoNegocioDAO ocorrenciaServicoDonoNegocioDAO;

	@Override
	protected OcorrenciaServicoDonoNegocioDAO getDao() {
		if (this.ocorrenciaServicoDonoNegocioDAO == null) {
			this.ocorrenciaServicoDonoNegocioDAO = new OcorrenciaServicoDonoNegocioDAO();
		}
		return this.ocorrenciaServicoDonoNegocioDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoDonoNegocioDTO> findOcorrenciaServicoDonoNegocioByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoDonoNegocioByIdOcorrenciaServico(idOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public void createOcorrenciaServicoDonoNegocio(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico, final DonoNegocioDTO donoNegocioOcorrenciaServico)
			throws Exception {
		try {
			this.getDao().createOcorrenciaServicoDonoNegocio(idOcorrenciaServico, listaIdsOcorrenciaServico, donoNegocioOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}
}
