package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoEsquemaDadosDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoEsquemaDadosDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoEsquemaDadosServiceEjb extends CrudServiceImpl implements OcorrenciaServicoEsquemaDadosService {

	private OcorrenciaServicoEsquemaDadosDAO ocorrenciaServicoEsquemaDadosDAO;

	@Override
	protected OcorrenciaServicoEsquemaDadosDAO getDao() {
		if (this.ocorrenciaServicoEsquemaDadosDAO == null) {
			this.ocorrenciaServicoEsquemaDadosDAO = new OcorrenciaServicoEsquemaDadosDAO();
		}
		return this.ocorrenciaServicoEsquemaDadosDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoEsquemaDadosDTO> findOcorrenciaServicoEsquemaDadosByIdOcorrenciaServico(Integer idOcorrenciaServico) throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoEsquemaDadosByIdOcorrenciaServico(idOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public void createOcorrenciaServicoEsquemaDados(Integer idOcorrenciaServico, String acaoOcorrenciaServico) throws Exception {
		try {
			this.getDao().createOcorrenciaServicoEsquemaDados(idOcorrenciaServico, acaoOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}
}
