package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoHabilidadeDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoHabilidadeDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoHabilidadeServiceEjb extends CrudServiceImpl implements OcorrenciaServicoHabilidadeService {

	private OcorrenciaServicoHabilidadeDAO ocorrenciaServicoHabilidadeDAO;

	@Override
	protected OcorrenciaServicoHabilidadeDAO getDao() {
		if (this.ocorrenciaServicoHabilidadeDAO == null) {
			this.ocorrenciaServicoHabilidadeDAO = new OcorrenciaServicoHabilidadeDAO();
		}
		return this.ocorrenciaServicoHabilidadeDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoHabilidadeDTO> findOcorrenciaServicoHabilidadeByIdOcorrenciaServico(Integer idOcorrenciaServico) throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoHabilidadeByIdOcorrenciaServico(idOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	@Override
	public void createOcorrenciaServicoHabilidade(Integer idOcorrenciaServico, List<Integer> listaIdsOcorrenciaServico, String acaoOcorrenciaServico) throws Exception {
		try {
			this.getDao().createOcorrenciaServicoHabilidade(idOcorrenciaServico, listaIdsOcorrenciaServico, acaoOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}
}
