package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoProcessoNegocioDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoProcessoNegocioDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoProcessoNegocioServiceEjb extends CrudServiceImpl implements OcorrenciaServicoProcessoNegocioService {

	private OcorrenciaServicoProcessoNegocioDAO ocorrenciaServicoProcessoNegocioDAO;

	@Override
	protected OcorrenciaServicoProcessoNegocioDAO getDao() {
		if (this.ocorrenciaServicoProcessoNegocioDAO == null) {
			this.ocorrenciaServicoProcessoNegocioDAO = new OcorrenciaServicoProcessoNegocioDAO();
		}
		return this.ocorrenciaServicoProcessoNegocioDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoProcessoNegocioDTO> findOcorrenciaServicoProcessoNegocioByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoProcessoNegocioByIdOcorrenciaServico(idOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public void createOcorrenciaServicoProcessoNegocio(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico, final String acaoOcorrenciaServico) throws Exception {
		try {
			this.getDao().createOcorrenciaServicoProcessoNegocio(idOcorrenciaServico, listaIdsOcorrenciaServico, acaoOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

}
