package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioProprietariosDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoProprietariosDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoProprietariosDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoProprietariosServiceEjb extends CrudServiceImpl implements OcorrenciaServicoProprietariosService {

	private OcorrenciaServicoProprietariosDAO ocorrenciaServicoProprietariosDAO;

	@Override
	protected OcorrenciaServicoProprietariosDAO getDao() {
		if (this.ocorrenciaServicoProprietariosDAO == null) {
			this.ocorrenciaServicoProprietariosDAO = new OcorrenciaServicoProprietariosDAO();
		}
		return this.ocorrenciaServicoProprietariosDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoProprietariosDTO> findOcorrenciaServicoProprietariosByIdOcorrenciaServico(Integer idOcorrenciaServico) throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoProprietariosByIdOcorrenciaServico(idOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public void createOcorrenciaServicoProprietarios(Integer idOcorrenciaServico, List<Integer> listaIdsProprietarios,
			GerenciamentoPortfolioProprietariosDTO gerenciamentoProprietarioOcorrenciaServico) throws Exception {
		try {
			this.getDao().createOcorrenciaServicoProprietarios(idOcorrenciaServico, listaIdsProprietarios, gerenciamentoProprietarioOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}
}
