package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaServicoRelacionadoDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoRelacionadoDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoRelacionadoServiceEjb extends CrudServiceImpl implements OcorrenciaServicoRelacionadoService {

	private OcorrenciaServicoRelacionadoDAO ocorrenciaServicoRelacionadoDAO;

	@Override
	protected OcorrenciaServicoRelacionadoDAO getDao() {
		if (this.ocorrenciaServicoRelacionadoDAO == null) {
			this.ocorrenciaServicoRelacionadoDAO = new OcorrenciaServicoRelacionadoDAO();
		}
		return this.ocorrenciaServicoRelacionadoDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoRelacionadoDTO> findOcorrenciaServicoRelacionadoByIdOcorrenciaServicoAndTipoServico(final Integer idOcorrenciaServico, final String tipoServicoRelacionado)
			throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoRelacionadoByIdOcorrenciaServicoAndTipoServico(idOcorrenciaServico, tipoServicoRelacionado);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public void createOcorrenciaServicoRelacionado(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico, final String acaoOcorrenciaServico, final String tipoServico)
			throws Exception {
		try {
			this.getDao().createOcorrenciaServicoRelacionado(idOcorrenciaServico, listaIdsOcorrenciaServico, acaoOcorrenciaServico, tipoServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}
}
