package br.com.centralit.citcorpore.negocio;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AtributoDemandaDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioOcorrenciasServicoDTO;
import br.com.centralit.citcorpore.bean.IndicadorCapacidadeDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoCapacidadeDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDemandaDTO;
import br.com.centralit.citcorpore.integracao.AtributoDemandaDao;
import br.com.centralit.citcorpore.integracao.IndicadorCapacidadeDao;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoCapacidadeDAO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoDAO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoDemandaDAO;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaTipos;
import br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilDatas;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoServiceEjb extends CrudServiceImpl implements OcorrenciaServicoService {

	private OcorrenciaServicoDAO ocorrenciaServicoDAO;

	@Override
	protected OcorrenciaServicoDAO getDao() {
		if (ocorrenciaServicoDAO == null) {
			ocorrenciaServicoDAO = new OcorrenciaServicoDAO();
		}
		return ocorrenciaServicoDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 27.01.2016
	 */
	@Override
	public Page<OcorrenciaServicoDTO> listOcorrenciasServico(GerenciamentoPortfolioOcorrenciasServicoDTO gerenciamentoPortfolioCadastroServicoDTO, Pageable pageable, Boolean isTotalizacao)
			throws PersistenceException {
		return this.getDao().listOcorrenciasServico(gerenciamentoPortfolioCadastroServicoDTO, pageable, isTotalizacao);
	}

	@Override
	public void salvaOcorrenciaServicoDemanda(Integer idServico, String acao, Integer[] demandas, DocumentHTML document, HttpServletRequest request) throws ServiceException, LogicException {
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		OcorrenciaServicoDemandaDAO demandaDAO = new OcorrenciaServicoDemandaDAO();
		AtributoDemandaDao atributoDemandaDAO = new AtributoDemandaDao();
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);


			if (idServico > 0) {
				ocorrenciaServicoDAO.setTransactionControler(tc);
				demandaDAO.setTransactionControler(tc);
				atributoDemandaDAO.setTransactionControler(tc);

				tc.start();
				OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.ATRIBUTO_DEMANDA.getIdentificador(), document, request);

				if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
					if (demandas != null && demandas.length > 0) {
						for (Integer idAtributoDemanda : demandas) {
							AtributoDemandaDTO atributoDemandaDTO = new AtributoDemandaDTO();
							OcorrenciaServicoDemandaDTO demandaDTO = new OcorrenciaServicoDemandaDTO();
							atributoDemandaDTO.setIdAtributoDemanda(idAtributoDemanda);
							atributoDemandaDTO = (AtributoDemandaDTO) atributoDemandaDAO.restore(atributoDemandaDTO);
							demandaDTO.setIdOcorrenciaServico(ocorrenciaServicoDTO.getIdOcorrenciaServico());
							demandaDTO.setNome(atributoDemandaDTO.getNome());
							demandaDTO.setValor(atributoDemandaDTO.getValor());
							demandaDTO.setAcaoOcorrenciaServico(acao);
							demandaDAO.create(demandaDTO);
						}
					}
				}
			}

			tc.commit();
			tc.close();
		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
		}
	}

	@Override
	public void salvaOcorrenciaServicoCapacidade(Integer idServico, String acao, Integer[] indicadores, DocumentHTML document, HttpServletRequest request) throws ServiceException, LogicException {
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());
		OcorrenciaServicoCapacidadeDAO capacidadeDAO = new OcorrenciaServicoCapacidadeDAO();
		IndicadorCapacidadeDao indicadorCapacidadeDAO = new IndicadorCapacidadeDao();
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);

			if (idServico > 0) {
				ocorrenciaServicoDAO.setTransactionControler(tc);
				capacidadeDAO.setTransactionControler(tc);
				indicadorCapacidadeDAO.setTransactionControler(tc);

				tc.start();
				OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.INDICADOR_CAPACIDADE.getIdentificador(), document, request);

				if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
					if (indicadores != null && indicadores.length > 0) {
						for (Integer idIndicadorCapacidade : indicadores) {
							IndicadorCapacidadeDTO indicadorCapacidadeDTO = new IndicadorCapacidadeDTO();
							OcorrenciaServicoCapacidadeDTO capacidadeDTO = new OcorrenciaServicoCapacidadeDTO();
							indicadorCapacidadeDTO.setIdIndicadorCapacidade(idIndicadorCapacidade);
							indicadorCapacidadeDTO = (IndicadorCapacidadeDTO) indicadorCapacidadeDAO.restore(indicadorCapacidadeDTO);
							capacidadeDTO.setIdOcorrenciaServico(ocorrenciaServicoDTO.getIdOcorrenciaServico());
							capacidadeDTO.setNome(indicadorCapacidadeDTO.getNome());
							capacidadeDTO.setValor(indicadorCapacidadeDTO.getValor());
							capacidadeDTO.setAcaoOcorrenciaServico(acao);
							capacidadeDAO.create(capacidadeDTO);
						}
					}
				}
			}

			tc.commit();
			tc.close();
		} catch (Exception e) {
			this.rollbackTransaction(tc, e);
		}
	}

	private OcorrenciaServicoDTO createOcorrenciaServicoAutomatica(Integer idServico, String categoriaOcorrencia, DocumentHTML document, HttpServletRequest request) throws Exception {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = new OcorrenciaServicoDTO();

			ocorrenciaServicoDTO.setIdServico(idServico);
			ocorrenciaServicoDTO.setTipoOcorrencia(AuditoriaTipos.AUTOMATICO.getIdentificador());
			ocorrenciaServicoDTO.setCategoriaOcorrencia(categoriaOcorrencia);

			ocorrenciaServicoDTO = createOcorrenciaServico(ocorrenciaServicoDTO, request);

			return ocorrenciaServicoDTO;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	private OcorrenciaServicoDTO createOcorrenciaServico(OcorrenciaServicoDTO ocorrenciaServicoDTO, HttpServletRequest request) throws Exception {
		ocorrenciaServicoDTO.setDataCriacao(UtilDatas.getDataHoraAtual());
		ocorrenciaServicoDTO.setNomeUsuario(WebUtil.getUsuario(request).getNomeUsuario());

		ocorrenciaServicoDTO = (OcorrenciaServicoDTO) getDao().create(ocorrenciaServicoDTO);

		return ocorrenciaServicoDTO;
	}

}
