package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioBusinessUserDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoUsuarioNegocioDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoUsuarioNegocioDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class OcorrenciaServicoUsuarioNegocioServiceEjb extends CrudServiceImpl implements OcorrenciaServicoUsuarioNegocioService {

	private OcorrenciaServicoUsuarioNegocioDAO ocorrenciaServicoUsuarioNegocioDAO;

	@Override
	protected OcorrenciaServicoUsuarioNegocioDAO getDao() {
		if (this.ocorrenciaServicoUsuarioNegocioDAO == null) {
			this.ocorrenciaServicoUsuarioNegocioDAO = new OcorrenciaServicoUsuarioNegocioDAO();
		}
		return this.ocorrenciaServicoUsuarioNegocioDAO;
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public Collection<OcorrenciaServicoUsuarioNegocioDTO> findOcorrenciaServicoUsuarioNegocioByIdOcorrenciaServico(final Integer idOcorrenciaServico) throws Exception {
		try {
			return this.getDao().findOcorrenciaServicoUsuarioNegocioByIdOcorrenciaServico(idOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 04.02.2016
	 */
	@Override
	public void createOcorrenciaServicoUsuarioNegocio(final Integer idOcorrenciaServico, final List<Integer> listaIdsOcorrenciaServico,
			final GerenciamentoPortfolioBusinessUserDTO usuarioNegocioOcorrenciaServico) throws Exception {
		try {
			this.getDao().createOcorrenciaServicoUsuarioNegocio(idOcorrenciaServico, listaIdsOcorrenciaServico, usuarioNegocioOcorrenciaServico);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}
}
