package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.Date;
import java.util.List;

import br.com.centralit.citcorpore.bean.OcorrenciaSolicitacaoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.service.CrudService;

/**
 * @author breno.guimaraes
 *
 */
public interface OcorrenciaSolicitacaoService extends CrudService {
	public Collection<OcorrenciaSolicitacaoDTO> findByIdSolicitacaoServico(Integer idSolicitacaoServicoParm) throws Exception;

	public OcorrenciaSolicitacaoDTO findUltimoByIdSolicitacaoServico(Integer idSolicitacaoServicoParm) throws Exception;

	public OcorrenciaSolicitacaoDTO findUltimoByIdSolicitacaoAndCategoria(Integer idSolicitacaoServicoParm, Integer categoria, TransactionControler tc) throws Exception;

	public Collection<OcorrenciaSolicitacaoDTO> findByIdPessoaEDataAtendidasGrupoTeste(Integer idPessoa, Date dataInicio, Date dataFim) throws Exception;

	public Collection<OcorrenciaSolicitacaoDTO> findByIdPessoaGrupoTeste(Integer idPessoa, Date dataInicio, Date dataFim) throws Exception;

	public OcorrenciaSolicitacaoDTO findByIdOcorrencia(Integer idOcorrencia) throws Exception;

	public long quantidadeDeOcorrenciasDeAlteracaoSlaPorNumeroDaSolicitacao(int idSolicitacaoServico) throws Exception;

	public void updateDataHora(OcorrenciaSolicitacaoDTO ocorrencia, Date data, String hora, TransactionControler tc) throws Exception;

	public List<OcorrenciaSolicitacaoDTO> findNaoSincronizadas(Integer idSolicitacaoServico, String origemSincronizacao, List<String> categorias) throws PersistenceException;

	public void updateNotNull(OcorrenciaSolicitacaoDTO ocorrencia, TransactionControler tc) throws PersistenceException;
}
