/**
 * CentralIT - CITSmart
 */
package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.PastaDTO;
import br.com.centralit.citcorpore.bean.PerfilAcessoPastaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.util.Enumerados.PermissaoAcessoPasta;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudService;

/**
 * Service de PerfilAcessoPasta.
 * 
 * @author valdoilo.damasceno
 */
public interface PerfilAcessoPastaService extends CrudService {

	/**
	 * Verifica se Usurio Pode Aprovar Base de Conhecimento da pasta Selecionada.
	 * 
	 * @param usuario
	 * @param idPasta
	 * @return Boolean
	 * @author valdoilo.damasceno
	 * @throws ServiceException
	 * @throws Exception
	 */
	public boolean verificarSeUsuarioAprovaBaseConhecimentoParaPastaSelecionada(UsuarioDTO usuario, Integer idPasta) throws ServiceException, Exception;

	public List<PerfilAcessoPastaDTO> validaPasta(UsuarioDTO usuario) throws Exception;

	public Collection<PerfilAcessoPastaDTO> findByIdPasta(Integer idPasta) throws Exception;

	/**
	 * Lista PERFILACESSOPASTA ATIVOS.
	 * 
	 * @param idPasta
	 * @return Collection<PerfilAcessoPastaDTO>
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	public Collection<PerfilAcessoPastaDTO> listByIdPasta(Integer idPasta) throws Exception;

	/**
	 * Verifica Permisso de Acesso a Pasta Informada de acordo com a Herana de Permisso, caso a Pasta possua..
	 * 
	 * @param usuario
	 * @param idPasta
	 * @return SemPermissao = Sem permisso de acesso; Leitura = Permisso de Leitura; LeituraGravacao = Permisso de Leitura/Gravao.
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	public PermissaoAcessoPasta verificarPermissaoDeAcessoPasta(UsuarioDTO usuario, PastaDTO pastaDto) throws Exception;
	
	/**
	 * @author rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
	 * @param idPasta
	 * @param idUsuario
	 * @return boolean
	 * @since 25/06/2015
	 */
	public boolean verificaPermissaoDeAcessoAdministradorDoUsuarioNaPasta(final Integer idPasta, final Integer idUsuario);
	
	/**
	 * @author rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
	 * @param usuarioDto
	 * @param pastaDto
	 * @return boolean
	 * @since 25/06/2015
	 */
	public boolean verificaPermissaoDeAcessoNaPasta(final UsuarioDTO usuarioDto, final PastaDTO pastaDto);
}
