/**
 * CentralIT - CITSmart
 */
package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.PastaDTO;
import br.com.centralit.citcorpore.bean.PerfilAcessoPastaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.PerfilAcessoPastaDAO;
import br.com.centralit.citcorpore.util.Enumerados.PermissaoAcessoPasta;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;

/**
 * EJB de PerfilAcessoPasta.
 *
 * @author valdoilo.damasceno
 */
public class PerfilAcessoPastaServiceEjb extends CrudServiceImpl implements PerfilAcessoPastaService {

    private PerfilAcessoPastaDAO dao;

    @Override
    protected PerfilAcessoPastaDAO getDao() {
        if (dao == null) {
            dao = new PerfilAcessoPastaDAO();
        }
        return dao;
    }

    private PastaService pastaService;

    private PastaService getPastaService() throws Exception {
        if (pastaService == null) {
            pastaService = (PastaService) ServiceLocator.getInstance().getService(PastaService.class, null);
        }
        return pastaService;
    }

    @Override
    public boolean verificarSeUsuarioAprovaBaseConhecimentoParaPastaSelecionada(final UsuarioDTO usuario, final Integer idPasta) throws Exception {
        return this.getDao().usuarioAprovaBaseConhecimentoParaPastaSelecionada(usuario, idPasta, new ArrayList<Integer>());
    }

    @Override
    public List<PerfilAcessoPastaDTO> validaPasta(final UsuarioDTO usuario) throws Exception {
        return this.getDao().validaPasta(usuario);
    }

    @Override
    public Collection<PerfilAcessoPastaDTO> findByIdPasta(final Integer idPasta) throws Exception {
        return this.getDao().findByIdPasta(idPasta);
    }

    @Override
    public Collection<PerfilAcessoPastaDTO> listByIdPasta(final Integer idPasta) throws Exception {
        return this.getDao().listByIdPasta(idPasta);
    }

    @Override
    public PermissaoAcessoPasta verificarPermissaoDeAcessoPasta(final UsuarioDTO usuario, PastaDTO pastaDto) throws Exception {
        pastaDto = this.getPastaService().obterHerancaDePermissao(pastaDto);
        PermissaoAcessoPasta permissao = null;
        if (pastaDto != null) {
            permissao = this.getDao().verificarPermissaoDeAcessoPasta(usuario, pastaDto.getId());
        }

        return permissao;
    }
    
    /**
     * Verifica se um usurio tem permisso de acesso a um pasta.
     * 
     * @author rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
     * @param UsuarioDTO
     *            usuarioDto
     * @param PastaDTO
     *            pastaDto
     * @return boolean
     * @since 25/06/2015
     */
    public boolean verificaPermissaoDeAcessoNaPasta(final UsuarioDTO usuarioDto, final PastaDTO pastaDto) {
        boolean temPermmissaoNaPasta = false;
        PermissaoAcessoPasta permissaoAcessoPasta;

        try {
            permissaoAcessoPasta = this.verificarPermissaoDeAcessoPasta(usuarioDto, pastaDto);
            if (permissaoAcessoPasta != null) {
                if (PermissaoAcessoPasta.LEITURA.equals(permissaoAcessoPasta) || PermissaoAcessoPasta.LEITURAGRAVACAO.equals(permissaoAcessoPasta)) {
                    temPermmissaoNaPasta = true;
                } else {
                    if (PermissaoAcessoPasta.SEMPERMISSAO.equals(permissaoAcessoPasta)) {
                        temPermmissaoNaPasta = false;
                    }
                }
            }
        } catch (IllegalArgumentException illegArgExc) {
            illegArgExc.printStackTrace();
            temPermmissaoNaPasta = false;
        } catch (PersistenceException perExc) {
            perExc.printStackTrace();
            temPermmissaoNaPasta = false;
        } catch (ServiceException servExc) {
            servExc.printStackTrace();
            temPermmissaoNaPasta = false;
        } catch (LogicException logicExc) {
            logicExc.printStackTrace();
            temPermmissaoNaPasta = false;
        } catch (Exception exc) {
            exc.printStackTrace();
            temPermmissaoNaPasta = false;
        }

        return temPermmissaoNaPasta;
    }
    
    /**
     * Verifica se um usurio tem permisso de administrador sobre uma pasta.
     * 
     * @author rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
     * @param Integer
     *            idPasta
     * @param Integer
     *            idUsuario
     * @return boolean
     * @since 25/06/2014
     */
    public boolean verificaPermissaoDeAcessoAdministradorDoUsuarioNaPasta(final Integer idPasta, final Integer idUsuario) {
        boolean temPermissaoAdministradorNaPasta = this.getDao().verificaPermissaoDeAcessoAdministradorNaPasta(idPasta, idUsuario);

        return temPermissaoAdministradorNaPasta;
    }

}
