package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.PermissaoAcessoPaginaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.PermissaoAcessoPaginaDao;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings("unchecked")
public class PermissaoAcessoPaginaServiceEjb extends CrudServiceImpl implements PermissaoAcessoPaginaService {

	private PermissaoAcessoPaginaDao dao;

	@Override
	protected PermissaoAcessoPaginaDao getDao() {
		if (dao == null) {
			dao = new PermissaoAcessoPaginaDao();
		}
		return dao;
	}

	@Override
	public Collection<PermissaoAcessoPaginaDTO> getPaginasByUsuario(UsuarioDTO usuario, Boolean isSomentePesquisa) throws Exception {
		return this.getDao().getPaginasByUsuario(usuario, isSomentePesquisa);
	}

	@Override
	public Collection<PermissaoAcessoPaginaDTO> getPaginasByPerfilAcesso(Integer idPerfilAcesso, Integer tipoPerfilAcesso) throws Exception {
		return this.getDao().getPaginasByPerfilAcesso(idPerfilAcesso, tipoPerfilAcesso);
	}

	@Override
	public void salvar(Integer idPerfilAcesso, Integer tipoPerfilAcesso, Collection<PermissaoAcessoPaginaDTO> permissaoAcessoPaginas) throws Exception {
		final TransactionControler tc = new TransactionControlerImpl(this.getDao().getAliasDB());

		try {
			this.getDao().setTransactionControler(tc);
			tc.start();

			if (this.getDao().isPermissaoAcessoJaExiste(idPerfilAcesso, tipoPerfilAcesso)) {
				for (PermissaoAcessoPaginaDTO pagina : permissaoAcessoPaginas) {
					pagina.setIdPerfilAcesso(idPerfilAcesso);
					pagina.setTipoPerfilAcesso(tipoPerfilAcesso);
					this.getDao().update(pagina);
				}
			} else {
				Integer i = 0;
				for (PermissaoAcessoPaginaDTO pagina : permissaoAcessoPaginas) {
					pagina.setIdPerfilAcesso(idPerfilAcesso);
					pagina.setTipoPerfilAcesso(tipoPerfilAcesso);
					if (UtilStrings.isNullOrEmpty(pagina.getCaminho())) {
						pagina.setCaminho(i.toString());
						i++;
					}
					this.getDao().create(pagina);
				}
			}

			tc.commit();
			tc.close();
		} catch (final Exception e) {
			try {
				this.rollbackTransaction(tc, e);
			} catch (ServiceException | LogicException e1) {
				e1.printStackTrace();
			}

			throw e;
		}
	}


}
