/**
 *
 */
package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;

import com.google.gson.Gson;

import br.com.centralit.citcorpore.bean.OcorrenciaSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.PesquisaSatisfacaoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.integracao.PesquisaSatisfacaoDAO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilStrings;

/**
 * @author valdoilo
 *
 */
@SuppressWarnings("unchecked")
public class PesquisaSatisfacaoServiceEjb extends CrudServiceImpl implements PesquisaSatisfacaoService {

    private PesquisaSatisfacaoDAO dao;
    private PesquisaSatisfacaoDAO daoDbAlias;

    @Override
    protected PesquisaSatisfacaoDAO getDao() {
        if (dao == null) {
            dao = new PesquisaSatisfacaoDAO();
        }
        return dao;
    }

    protected PesquisaSatisfacaoDAO getDao(String databaseAlias) {
		if (UtilStrings.isNotVazio(databaseAlias)) {
			if (daoDbAlias == null) {
				daoDbAlias = new PesquisaSatisfacaoDAO(databaseAlias);
			}
			return daoDbAlias;
		}
		return this.getDao();
	}

    @Override
    public Collection<PesquisaSatisfacaoDTO> getPesquisaByIdSolicitacao(final int idServico) {
        return this.getDao().getPesquisaByIdSolicitacao(idServico);
    }

    @Override
    public Collection<PesquisaSatisfacaoDTO> relatorioPesquisaSatisfacao(final PesquisaSatisfacaoDTO pesquisaSatisfacaoDTO) throws Exception {
        if(Objects.equals(pesquisaSatisfacaoDTO.getDataInicio(), null) || Objects.equals(pesquisaSatisfacaoDTO.getDataFim(), null)){
            return null;
        }

        return this.getDao(pesquisaSatisfacaoDTO.getBaseReports() ? CITCorporeUtil.JDBC_ALIAS_REPORTS : null).relatorioPesquisaSatisfacao(pesquisaSatisfacaoDTO);
    }

    public String buscarResponsavelExecucao(final Integer idSolcilitacao, HttpServletRequest request) throws Exception {
        final OcorrenciaSolicitacaoService ocorrenciaSolicitacaoService = (OcorrenciaSolicitacaoService) ServiceLocator.getInstance().getService(
                OcorrenciaSolicitacaoService.class, null);
		final Collection<OcorrenciaSolicitacaoDTO> col = ocorrenciaSolicitacaoService.findByIdSolicitacaoServico(idSolcilitacao);
        for (final OcorrenciaSolicitacaoDTO ocorrenciaSolicitacaoDTO : col) {
            String dadosSolicitacao = UtilStrings.nullToVazio(ocorrenciaSolicitacaoDTO.getDadosSolicitacao());
            SolicitacaoServicoDTO solicitacaoDto = null;
            if (dadosSolicitacao.length() > 0) {
                try {
                    solicitacaoDto = new Gson().fromJson(dadosSolicitacao, SolicitacaoServicoDTO.class);
                    if (solicitacaoDto != null) {
                        dadosSolicitacao = solicitacaoDto.recuperaDadosStr(usuario.getLocale());

						if (ServiceRequestStatus.SOLVED.getId().equals(solicitacaoDto.getIdStatus()) && !solicitacaoDto.getRegistradoPor().equals("Automtico")) {
                            return solicitacaoDto.getRegistradoPor();
                        }
                    }
                } catch (final Exception e) {
                    dadosSolicitacao = "";
                }
            }
        }
        return null;
    }

    @Override
    public PesquisaSatisfacaoDTO findByIdSolicitacaoServico(final Integer idSolicitacaoServico) throws Exception {
        try {
            return this.getDao().findByIdSolicitacaoServico(idSolicitacaoServico);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

}
