package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.PortfolioServicoDTO;
import br.com.centralit.citcorpore.integracao.PortfolioServicoDao;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class PortfolioServicoServiceEjb extends CrudServiceImpl implements PortfolioServicoService {

	private PortfolioServicoDao dao;

	@Override
	protected PortfolioServicoDao getDao() {
		if (dao == null) {
			dao = new PortfolioServicoDao();
		}
		return dao;
	}

	@Override
	public Collection<PortfolioServicoDTO> findAtivos() throws Exception {
		return this.getDao().findAtivos();
	}

	@Override
	public Collection<PortfolioServicoDTO> findDisponiveisPortal(String nome) throws Exception {
		return this.getDao().findDisponiveisPortal(nome);
	}

	@Override
	public void updateNotNull(PortfolioServicoDTO portfolioServicoDTO) throws Exception {
		this.getDao().updateNotNull(portfolioServicoDTO);
	}

	@Override
	public List<PortfolioServicoDTO> findDisponiveisPortalByContratos(String nomePortal, Collection<ContratoDTO> contratosDTO) throws Exception {
		return this.getDao().findDisponiveisPortalByContratos(nomePortal, contratosDTO);
	}

}
