package br.com.centralit.citcorpore.negocio;

import java.util.Collection;

import br.com.centralit.citcorpore.bean.ProcessoNegocioDTO;
import br.com.centralit.citcorpore.bean.ProcessoNegocioTiposFluxoDTO;
import br.com.centralit.citcorpore.bean.ProcessoNegocioUnidadesDTO;
import br.com.centralit.citcorpore.integracao.ProcessoNegocioDao;
import br.com.centralit.citcorpore.integracao.ProcessoNegocioTiposFluxoDAO;
import br.com.centralit.citcorpore.integracao.ProcessoNegocioUnidadesDAO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class ProcessoNegocioServiceEjb extends CrudServiceImpl implements ProcessoNegocioService {

    private ProcessoNegocioDao dao;

    @Override
    protected ProcessoNegocioDao getDao() {
        if (dao == null) {
            dao = new ProcessoNegocioDao();
        }
        return dao;
    }

    @Override
    public IDto create(final IDto model) throws ServiceException, LogicException {
        final ProcessoNegocioDao processoNegocioDao = this.getDao();
        final ProcessoNegocioTiposFluxoDAO processoNegocioTiposFluxoDAO = new ProcessoNegocioTiposFluxoDAO();
        final ProcessoNegocioUnidadesDAO processoNegocioUnidadesDAO = new ProcessoNegocioUnidadesDAO();
        final TransactionControler tc = new TransactionControlerImpl(processoNegocioDao.getAliasDB());

        try {
            this.validaCreate(model);

            processoNegocioDao.setTransactionControler(tc);
            processoNegocioTiposFluxoDAO.setTransactionControler(tc);
            processoNegocioUnidadesDAO.setTransactionControler(tc);

            tc.start();

            ProcessoNegocioDTO processoNegocioDto = (ProcessoNegocioDTO) model;

            if (processoNegocioDto.getPercDispensaNovaAprovacao() == null) {
                processoNegocioDto.setPercDispensaNovaAprovacao(new Double(0));
            }

            processoNegocioDto = (ProcessoNegocioDTO) processoNegocioDao.create(processoNegocioDto);

            this.vinculaFluxos(processoNegocioDto, processoNegocioTiposFluxoDAO);
            this.vinculaUnidades(processoNegocioDto, processoNegocioUnidadesDAO);

            tc.commit();
            tc.close();
        } catch (final Exception e) {
            this.rollbackTransaction(tc, e);
        }
        return model;
    }

    @Override
    public void update(final IDto model) throws ServiceException, LogicException {
        final ProcessoNegocioDao processoNegocioDao = this.getDao();
        final ProcessoNegocioTiposFluxoDAO processoNegocioTiposFluxoDAO = new ProcessoNegocioTiposFluxoDAO();
        final ProcessoNegocioUnidadesDAO processoNegocioUnidadesDAO = new ProcessoNegocioUnidadesDAO();
        final TransactionControler tc = new TransactionControlerImpl(processoNegocioDao.getAliasDB());

        try {
            this.validaUpdate(model);

            processoNegocioDao.setTransactionControler(tc);
            processoNegocioTiposFluxoDAO.setTransactionControler(tc);
            processoNegocioUnidadesDAO.setTransactionControler(tc);

            tc.start();

            final ProcessoNegocioDTO processoNegocioDto = (ProcessoNegocioDTO) model;
            processoNegocioDao.update(processoNegocioDto);
            
        	this.vinculaFluxos(processoNegocioDto, processoNegocioTiposFluxoDAO);
        	this.vinculaUnidades(processoNegocioDto, processoNegocioUnidadesDAO);

            tc.commit();
            tc.close();
        } catch (final Exception e) {
            this.rollbackTransaction(tc, e);
        }

    }
    

    @Override
    public void delete(final IDto model) throws ServiceException, LogicException {
        final ProcessoNegocioDao processoNegocioDao = this.getDao();
        final TransactionControler tc = new TransactionControlerImpl(processoNegocioDao.getAliasDB());

        try {
            this.validaDelete(model);

            processoNegocioDao.setTransactionControler(tc);
            
            tc.start();

            final ProcessoNegocioDTO processoNegocioDto = (ProcessoNegocioDTO) model;
            processoNegocioDto.setDeleted("Y");
            processoNegocioDao.update(processoNegocioDto);
            
            tc.commit();
            tc.close();
        } catch (final Exception e) {
            this.rollbackTransaction(tc, e);
        }
    }
    
	@Override
	public ProcessoNegocioDTO findProcessoNegocioById(Integer idProcessoNegocio) throws Exception {
		try {
			return this.getDao().findById(idProcessoNegocio);			
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	private void vinculaFluxos(final ProcessoNegocioDTO processoNegocioDto, final ProcessoNegocioTiposFluxoDAO processoNegocioTiposFluxoDAO) throws Exception {
    	Integer idProcessoNegocio = processoNegocioDto.getIdProcessoNegocio();
    	processoNegocioTiposFluxoDAO.deleteAllTiposFluxoFromProcessoNegocio(idProcessoNegocio);
    	Collection<ProcessoNegocioTiposFluxoDTO> listaProcessoNegocioTipoFluxoDTO = processoNegocioDto.getListaProcessoNegocioTiposFluxo();
    	
    	if (listaProcessoNegocioTipoFluxoDTO != null) {
            for (final ProcessoNegocioTiposFluxoDTO processoNegocioTiposFluxoDTO : listaProcessoNegocioTipoFluxoDTO) {            	
            	processoNegocioTiposFluxoDTO.setIdProcessoNegocio(idProcessoNegocio);
            	processoNegocioTiposFluxoDAO.create(processoNegocioTiposFluxoDTO);
            }
        }
    }
    
    private void vinculaUnidades(final ProcessoNegocioDTO processoNegocioDto, final ProcessoNegocioUnidadesDAO processoNegocioUnidadesDAO) throws Exception {
    	Integer idProcessoNegocio = processoNegocioDto.getIdProcessoNegocio();
    	processoNegocioUnidadesDAO.deleteAllUnidadesFromProcessoNegocio(idProcessoNegocio);
    	Collection<ProcessoNegocioUnidadesDTO> listaProcessoNegocioUnidadesDTO = processoNegocioDto.getListaProcessoNegocioUnidades();
    	
    	if (listaProcessoNegocioUnidadesDTO != null) {
            for (final ProcessoNegocioUnidadesDTO processoNegocioUnidadesDTO : listaProcessoNegocioUnidadesDTO) {            	
            	processoNegocioUnidadesDTO.setIdProcessoNegocio(idProcessoNegocio);
            	processoNegocioUnidadesDAO.create(processoNegocioUnidadesDTO);
            }
        }
    }
    
    @Override
    public Page<ProcessoNegocioDTO> listProcessoDeNegocio(Integer idServico, String filtroProcessoNegocio, Pageable pageable, Boolean isTotalizacao) throws PersistenceException {
    	return this.getDao().listProcessoDeNegocio(idServico, filtroProcessoNegocio, pageable, isTotalizacao);
    }
    
    // TODO [deborah.ferreira][13/01/2016] Verificar Necessidade
    /*private void vinculaAutoridades(final ProcessoNegocioDTO processoNegocioDto, final ProcessoNivelAutoridadeDao processoNivelAutoridadeDao) throws Exception {
        processoNivelAutoridadeDao.deleteByIdProcessoNegocio(processoNegocioDto.getIdProcessoNegocio());
        if (processoNegocioDto.getColAutoridades() != null) {
            for (final ProcessoNivelAutoridadeDTO autoridadeDto : processoNegocioDto.getColAutoridades()) {
                if (autoridadeDto.getIdNivelAutoridade() == null) {
                    throw new Exception("Nvel de autoridade no informada");
                }
                if (autoridadeDto.getAntecedenciaMinimaAprovacao() == null) {
                    autoridadeDto.setAntecedenciaMinimaAprovacao(new Integer(0));
                }
                if (autoridadeDto.getPermiteSolicitacao() == null || autoridadeDto.getPermiteSolicitacao().trim().equals("")) {
                    autoridadeDto.setPermiteSolicitacao("S");
                }
                autoridadeDto.setIdProcessoNegocio(processoNegocioDto.getIdProcessoNegocio());
                processoNivelAutoridadeDao.create(autoridadeDto);
            }
        }
    }*/

}
