package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.bpm.dto.TipoFluxoDTO;
import br.com.centralit.bpm.integracao.TipoFluxoDao;
import br.com.centralit.citcorpore.bean.ProcessoNegocioTiposFluxoDTO;
import br.com.centralit.citcorpore.integracao.ProcessoNegocioTiposFluxoDAO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class ProcessoNegocioTiposFluxoServiceEjb extends CrudServiceImpl implements ProcessoNegocioTiposFluxoService {

	private ProcessoNegocioTiposFluxoDAO dao;

	@Override
	protected ProcessoNegocioTiposFluxoDAO getDao() {
		if (this.dao == null) {
			this.dao = new ProcessoNegocioTiposFluxoDAO();
		}
		return this.dao;
	}

	@Override
	public Collection<TipoFluxoDTO> findTiposFluxoByIdProcessoNegocio(final Integer idProcessoNegocio) throws Exception {
		try {
			Collection<ProcessoNegocioTiposFluxoDTO> listaIds = this.getDao().findIdsTiposFluxoByIdProcessoNegocio(idProcessoNegocio);
			Collection<TipoFluxoDTO> lista = new ArrayList<TipoFluxoDTO>();
			TipoFluxoDao TipoFluxoDAO = new TipoFluxoDao();
			if (listaIds != null && !listaIds.isEmpty()) {
				for (ProcessoNegocioTiposFluxoDTO dto : listaIds) {
					lista.add(TipoFluxoDAO.findById(dto.getIdTipoFluxo()));
				}
			}
			return lista;
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public void deleteAllTiposFluxoFromProcessoNegocio(final Integer idProcessoNegocio) throws Exception {
		try {
			this.getDao().deleteAllTiposFluxoFromProcessoNegocio(idProcessoNegocio);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

}
