package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.ProcessoNegocioUnidadesDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.integracao.ProcessoNegocioUnidadesDAO;
import br.com.centralit.citcorpore.integracao.UnidadeDao;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

@SuppressWarnings("unchecked")
public class ProcessoNegocioUnidadesServiceEjb extends CrudServiceImpl implements ProcessoNegocioUnidadesService {

	private ProcessoNegocioUnidadesDAO dao;

	@Override
	protected ProcessoNegocioUnidadesDAO getDao() {
		if (this.dao == null) {
			this.dao = new ProcessoNegocioUnidadesDAO();
		}
		return this.dao;
	}

	@Override
	public Collection<UnidadeDTO> findUnidadesByIdProcessoNegocio(final Integer idProcessoNegocio) throws Exception {
		try {
			Collection<ProcessoNegocioUnidadesDTO> listaIds = this.getDao().findIdsUnidadesByIdProcessoNegocio(idProcessoNegocio);
			Collection<UnidadeDTO> lista = new ArrayList<UnidadeDTO>();
			UnidadeDao unidadeDAO = new UnidadeDao();
			if (listaIds != null && !listaIds.isEmpty()) {
				for (ProcessoNegocioUnidadesDTO dto : listaIds) {
					lista.add(unidadeDAO.listUnidadeById(dto.getIdUnidade()));
				}
			}
			return lista;
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

	@Override
	public void deleteAllUnidadesFromProcessoNegocio(final Integer idProcessoNegocio) throws Exception {
		try {
			this.getDao().deleteAllUnidadesFromProcessoNegocio(idProcessoNegocio);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

}
