package br.com.centralit.citcorpore.negocio;

import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.RecursoProjetoDTO;
import br.com.centralit.citcorpore.integracao.RecursoProjetoDao;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.CrudServiceImpl;

public class RecursoProjetoServiceEjb extends CrudServiceImpl implements RecursoProjetoService {

    private RecursoProjetoDao dao;

    @Override
    protected RecursoProjetoDao getDao() {
        if (dao == null) {
            dao = new RecursoProjetoDao();
        }
        return dao;
    }

    @Override
    public Collection findByIdProjeto(final Integer parm) throws Exception {
        try {
            return getDao().findByIdProjeto(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void deleteByIdProjeto(final Integer parm) throws Exception {
        try {
            getDao().deleteByIdProjeto(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public Collection findByIdEmpregado(final Integer parm) throws Exception {
        try {
            return getDao().findByIdEmpregado(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void deleteByIdEmpregado(final Integer parm) throws Exception {
        try {
            getDao().deleteByIdEmpregado(parm);
        } catch (final Exception e) {
            throw new ServiceException(e);
        }
    }

	@Override
	public List<RecursoProjetoDTO> findRecursoProjetoComEmpregadoByIdProjeto(Integer idProjeto) throws Exception {
		try {
			return getDao().findRecursoProjetoComEmpregadoByIdProjeto(idProjeto);
		} catch (final Exception e) {
			throw new ServiceException(e);
		}
	}

}
