package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;
import java.util.Collection;

import br.com.centralit.citcorpore.bean.RelatorioDocumentosAcessadosBaseConhecimentoDTO;
import br.com.centralit.citcorpore.integracao.RelatorioDocumentosAcessadosBaseConhecimentoDAO;
import br.com.centralit.citcorpore.integracao.RelatorioSolicitacaoReabertaDAO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings("unchecked")
public class RelatorioDocumentosAcessadosBaseConhecimentoServiceEjb extends CrudServiceImpl implements RelatorioDocumentosAcessadosBaseConhecimentoService {

    private RelatorioSolicitacaoReabertaDAO dao;
    private RelatorioDocumentosAcessadosBaseConhecimentoDAO baseConhecimentoDAO;
    private RelatorioDocumentosAcessadosBaseConhecimentoDAO baseConhecimentoDAOReports;

    @Override
    protected RelatorioSolicitacaoReabertaDAO getDao() {
        if (dao == null) {
            dao = new RelatorioSolicitacaoReabertaDAO();
        }
        return dao;
    }
    
    /**
	 * Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 08:13 - ID Citsmart: 176362 -
	 * Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
	 * @param databaseAlias
	 * @return dao com o databaseAlias especificado, caso esteja preenchido, seno dao com o datasource principal
	 */
    private RelatorioDocumentosAcessadosBaseConhecimentoDAO getBaseConhecimentoDAO(String aliasDB) {
    	if (UtilStrings.isNotVazio(aliasDB)) {
			if (baseConhecimentoDAOReports == null) {
				baseConhecimentoDAOReports = new RelatorioDocumentosAcessadosBaseConhecimentoDAO(aliasDB);
			}
			return baseConhecimentoDAOReports;
		}
		return this.getBaseConhecimentoDAO();
    }
    

    private RelatorioDocumentosAcessadosBaseConhecimentoDAO getBaseConhecimentoDAO() {
        if (baseConhecimentoDAO == null) {
            baseConhecimentoDAO = new RelatorioDocumentosAcessadosBaseConhecimentoDAO();
        }
        return baseConhecimentoDAO;
    }

    @Override
    public Collection<RelatorioDocumentosAcessadosBaseConhecimentoDTO> listarDocumentosAcessadosBaseConhecimentoAnalitico(
            final RelatorioDocumentosAcessadosBaseConhecimentoDTO relatorioDocumentosAcessadosBaseConhecimentoDTO) {
        return this.getBaseConhecimentoDAO().listarDocumentosAcessadosBaseConhecimentoAnalitico(relatorioDocumentosAcessadosBaseConhecimentoDTO);
    }

    @Override
    public ArrayList<RelatorioDocumentosAcessadosBaseConhecimentoDTO> listarDocumentosAcessadosBaseConhecimentoResumido(
            final RelatorioDocumentosAcessadosBaseConhecimentoDTO relatorioDocumentosAcessadosBaseConhecimentoDTO) {
    	 /**
    	 * Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 08:20 - ID Citsmart: 176362 -
    	 * Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
    	 * @param databaseAlias
    	 * @return dao com o databaseAlias especificado, caso esteja preenchido, seno dao com o datasource principal
    	 */
        return this.getBaseConhecimentoDAO(CITCorporeUtil.JDBC_ALIAS_REPORTS).listarDocumentosAcessadosBaseConhecimentoResumido(relatorioDocumentosAcessadosBaseConhecimentoDTO);
    }

}
