package br.com.centralit.citcorpore.negocio;

import java.util.ArrayList;

import br.com.centralit.citcorpore.bean.RelatorioSolicitacaoReabertaDTO;
import br.com.centralit.citcorpore.integracao.RelatorioSolicitacaoReabertaDAO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.service.CrudServiceImpl;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings("unchecked")
public class RelatorioSolicitacaoReabertaServiceEjb extends CrudServiceImpl implements RelatorioSolicitacaoReabertaService {
    private RelatorioSolicitacaoReabertaDAO dao;
    private RelatorioSolicitacaoReabertaDAO daoReports;

    @Override
    protected RelatorioSolicitacaoReabertaDAO getDao() {
        if (dao == null) {
            dao = new RelatorioSolicitacaoReabertaDAO();
        }
        return dao;
    }
    
	/**
	 * Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 11:11 - ID Citsmart: 176362 -
	 * Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
	 * @param databaseAlias
	 * @return dao com o databaseAlias especificado, caso esteja preenchido, seno dao com o datasource principal
	 */
    private RelatorioSolicitacaoReabertaDAO getDao(final String databaseAlias) {
		if (UtilStrings.isNotVazio(databaseAlias)) {
			if (daoReports == null) {
				daoReports = new RelatorioSolicitacaoReabertaDAO(databaseAlias);
			}
			return daoReports;
		}
		return this.getDao();
	}


    @Override
    public ArrayList<RelatorioSolicitacaoReabertaDTO> listSolicitacaoReaberta(final RelatorioSolicitacaoReabertaDTO relatorioSolicitacaoReabertaDTO) {
    	 // Desenvolvedor: ibimon.morais - Data: 18/08/2015 - Horrio: 11:13 - ID Citsmart: 176362 -
    	 // Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
    	 // @param databaseAlias
    	 // @return dao com o databaseAlias especificado, caso esteja preenchido, seno dao com o datasource principal
    	 
        return this.getDao(CITCorporeUtil.JDBC_ALIAS_REPORTS).listSolicitacaoReaberta(relatorioSolicitacaoReabertaDTO);
    }

}
